/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.domain.logic.TopologyServiceHelper;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.equipmentmanager.EquipmentEditorContainer;
import com.bwanms.mediation.util.EventFacade;
import com.bwanms.model.Contact;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ObjectID;
import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.model.fault.Event;
import com.bwanms.model.license.Licensable;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.ServiceException;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentPersister<E extends Equipment>
extends PersisterAdapter<E> {
    private boolean newEquipment = false;

    @Override
    public void persistBeforeSave(E entity) throws ServiceException {
        Contact contact;
        Location location;
        super.persistBeforeSave(entity);
        if (((ManagedEntityBase)entity).getId() == 0L) {
            ManagedEntityBase.persist(Datastore.session(), entity);
            this.newEquipment = true;
        } else {
            this.newEquipment = false;
        }
        if (entity instanceof Licensable) {
            LicenseHelper.licenseEntity((Licensable)entity);
        }
        if (((Equipment)entity).getLocation() != null && (location = (Location)Datastore.session().get(Location.class, (Serializable)Long.valueOf(((Equipment)entity).getLocation().getId()))) == null) {
            Internationalizer i18n = Internationalizer.getInternationalizer(EquipmentEditorContainer.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("deletedLocationException"), Location.class, "location", (Object)((Equipment)entity).getLocation().getName(), (Object)((Equipment)entity).getLocation()));
            throw new ServerValidationException(iValues);
        }
        if (((Equipment)entity).getContact() != null && (contact = (Contact)Datastore.session().get(Contact.class, (Serializable)Long.valueOf(((Equipment)entity).getContact().getId()))) == null) {
            Internationalizer i18n = Internationalizer.getInternationalizer(EquipmentEditorContainer.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("deletedContactException"), Contact.class, "contact", (Object)((Equipment)entity).getContact().getContactId(), (Object)((Equipment)entity).getContact()));
            throw new ServerValidationException(iValues);
        }
    }

    @Override
    public void persistAfterSave(E entity) throws ServiceException {
        Event event;
        Location location = ((Equipment)entity).getLocation();
        if (location != null) {
            TopologyServiceHelper.topologyChanged(new ObjectID(Location.class.getName(), Long.valueOf(location.getId())));
        }
        if (this.newEquipment && (event = Helpers.getDDCallback().equipmentCreate(null, (Equipment)entity)) != null) {
            EventFacade.emitEvent(event);
        }
    }

    @Override
    public void persistBeforeDelete(E entity) throws ServiceException {
        try {
            DDInterface ddi = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(entity.getClass().getName());
            if (null == ddi) {
                throw new ServiceException("Can't determine DDInterface for equipment type: " + entity.getClass().getName());
            }
            ddi.deleteEquipment((Equipment)entity, Helpers.getDDCallback());
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void persistAfterDelete(E entity) throws ServiceException {
        super.persistAfterDelete(entity);
        Event event = Helpers.getDDCallback().equipmentRemove(null, (Equipment)entity);
        if (event != null) {
            EventFacade.emitEvent(event);
        }
    }
}

