/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.contactmanager.ContactManagerConfig;
import com.bwanms.gui.contactmanager.ContactView;
import com.bwanms.model.Contact;
import com.bwanms.model.Contactable;
import com.bwanms.model.Equipment;
import com.bwanms.model.SingleRangeScanTask;
import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.ServiceException;
import com.bwanms.util.ServerValidationException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactPersister
extends PersisterAdapter<Contact> {
    @Override
    public void persistBeforeSave(Contact entity) throws ServiceException {
        String query = " from " + Contact.class.getName() + " as contact where contact.contactId=:name and contact.id!=:id";
        List match = Datastore.session().createQuery(query).setString("name", entity.getContactId()).setLong("id", entity.getId()).list();
        if (match.size() > 0) {
            Internationalizer i18n = Internationalizer.getInternationalizer(ContactView.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("uniqueViolation"), Contact.class, "contactId", (Object)entity.getContactId(), (Object)entity));
            throw new ServerValidationException(iValues);
        }
    }

    @Override
    public void persistBeforeDelete(Contact entity) throws ServiceException {
        String query = " from " + Contactable.class.getName() + " as contactable where contactable.contact.id=:id";
        List match = Datastore.session().createQuery(query).setLong("id", entity.getId()).list();
        if (match.size() > 0) {
            BitSet matchFlag = new BitSet();
            for (int i = 0; i < match.size(); ++i) {
                Contactable contact = (Contactable)match.get(i);
                if (contact instanceof Equipment) {
                    matchFlag.set(0);
                    break;
                }
                if (!(contact instanceof SingleRangeScanTask)) continue;
                matchFlag.set(1);
            }
            String errorMsgKey = "contactViolation";
            if (matchFlag.get(0)) {
                errorMsgKey = "contactViolationEquipment";
            } else if (matchFlag.get(1)) {
                errorMsgKey = "contactViolationTask";
            }
            Internationalizer i18n = Internationalizer.getInternationalizer(ContactManagerConfig.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString(errorMsgKey), Contact.class, "", null, null));
            throw new ServerValidationException(iValues);
        }
    }
}

