/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.model.fault.Command;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPersister
extends PersisterAdapter<Command> {
    @Override
    public void persistBeforeDelete(Command entity) throws ServiceException {
        String query = " select count(etb) from " + EventTemplateBehavior.class.getName() + " as etb where etb.scriptCommand = :scriptCommand";
        Integer count = (Integer)Datastore.session().createQuery(query).setEntity("scriptCommand", (Object)entity).uniqueResult();
        if (count > 0) {
            String errorMsgKey = "commandViolation";
            throw new ServiceException("com.bwanms.client.gui.fault.commands.CommandsManagerConfig", errorMsgKey);
        }
    }

    @Override
    public void persistBeforeSave(Command entity) throws ServiceException {
        long id;
        Command command = this.findCommandByName(entity.getName());
        if (command != null && ((id = entity.getId()) == 0L || id != command.getId())) {
            throw new EntityAlreadyExistsException(entity.getName());
        }
        Datastore.session().evict((Object)command);
        super.persistBeforeSave(entity);
    }

    protected Command findCommandByName(String name) {
        Query query = Datastore.session().createQuery(" from " + Command.class.getName() + " where name = :name ").setString("name", name);
        return (Command)query.uniqueResult();
    }
}

