/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity;

import com.bwanms.model.entity.Persister;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.CachedClassMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Persisters {
    private static final Logger logger = Logger.getLogger(Persisters.class);
    private static Persisters instance;
    private CachedClassMap<Persister> persisters;

    private static Persisters instance() {
        if (instance == null) {
            instance = new Persisters();
        }
        return instance;
    }

    public static <E extends Serializable> Persister<E> getPersister(Class<? extends E> baseClass) {
        return Persisters.instance().getPersisterImpl(baseClass);
    }

    private Persisters() {
        this.configure();
    }

    private <E extends Serializable> void configure() {
        logger.info((Object)"Initializing Persisters...");
        this.persisters = new CachedClassMap();
        try {
            IConfigurationElement[] elements;
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.model.persisters");
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                try {
                    Persister persister = (Persister)element.createExecutableExtension("class");
                    String targetClass = element.getAttribute("targetClass");
                    this.persisters.put(this.getClass().getClassLoader(), targetClass, persister);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.info((Object)"Persisters initialized");
    }

    public <E extends Serializable> Persister<E> getPersisterImpl(Class<? extends E> baseClass) {
        Persister persister = null;
        if (this.persisters.findBottomUp(baseClass) == null) {
            persister = null;
        } else {
            Collection<Persister> values = this.persisters.findBottomUp(baseClass).values();
            if (values == null || values.isEmpty()) {
                persister = null;
            } else {
                Iterator<Persister> it = values.iterator();
                if (it != null && it.hasNext()) {
                    persister = it.next();
                }
            }
        }
        return persister;
    }
}

