/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity;

import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.AssemblerFactory;
import com.bwanms.model.entity.Assembly;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.ServiceException;
import com.bwanms.util.CachedClassMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assemblers {
    private static final Logger logger = Logger.getLogger(Assemblers.class);
    private static Assemblers instance;
    private CachedClassMap<AssemblerFactory> factories;

    private static Assemblers instance() {
        if (instance == null) {
            instance = new Assemblers();
        }
        return instance;
    }

    public static <E extends Serializable> Assembly<E> assemble(E entity, String assembler) throws ServiceException {
        if (Assemblers.instance().getAssemblerImpl(entity.getClass(), assembler) != null) {
            return Assemblers.instance().getAssemblerImpl(entity.getClass(), assembler).getAssembly(entity);
        }
        return null;
    }

    public static <E extends Serializable> Assembler<E> getAssembler(Class<? extends E> clazz, String assembler) {
        return Assemblers.instance().getAssemblerImpl(clazz, assembler);
    }

    private Assemblers() {
        this.configure();
    }

    private void configure() {
        logger.info((Object)"Initializing Assemblers...");
        this.factories = new CachedClassMap();
        try {
            IConfigurationElement[] elements;
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.model.assemblers");
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                try {
                    AssemblerFactory factory = (AssemblerFactory)element.createExecutableExtension("class");
                    String targetClass = element.getAttribute("targetClass");
                    this.factories.put(this.getClass().getClassLoader(), targetClass, factory);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.info((Object)"Assemblers initialized");
    }

    public <E extends Serializable> Assembler<E> getAssemblerImpl(Class<? extends E> clazz, String assembler) {
        AssemblerFactory factory = null;
        if (this.factories.findBottomUp(clazz) == null) {
            factory = null;
        } else {
            Collection<AssemblerFactory> values = this.factories.findBottomUp(clazz).values();
            if (values == null || values.isEmpty()) {
                factory = null;
            } else {
                Iterator<AssemblerFactory> it = values.iterator();
                if (it != null && it.hasNext()) {
                    factory = it.next();
                }
            }
        }
        return factory != null ? factory.createAssembler(clazz, assembler) : null;
    }
}

