/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Schedule;
import com.bwanms.model.Task;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@Entity
@Table(name="BwTaskSchedule")
public class TaskSchedule
extends Schedule {
    private static final long serialVersionUID = 8970966449832988517L;
    private static final Logger log = Logger.getLogger(TaskSchedule.class);
    private Task task;

    @Transient
    public Runnable getRunnableJob() {
        return new Runnable(){

            public void run() {
                try {
                    ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "TaskStart", "TaskManager", TaskSchedule.this.task.getName(), TaskSchedule.this.task.getClass().getName());
                    ServiceRegistry.getTaskManagerService().startTask(TaskSchedule.this.task.getId());
                }
                catch (Exception ex) {
                    log.error((Object)"Task starting on schedule FAILED", (Throwable)ex);
                }
            }
        };
    }

    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="task_id")
    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }
}

