/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Task;
import com.bwanms.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.validator.Length;

@Entity
@Table(name="BwTaskRunResult")
public final class TaskRunResult
implements Serializable {
    private static final long serialVersionUID = 5320290223939571950L;
    private static final Logger log = Logger.getLogger(TaskRunResult.class);
    private long id;
    private Task task;
    private long start;
    private long end;
    private int result;
    private byte[] reportBytes;

    @Column(name="theEnd")
    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Transient
    public String getReport() {
        try {
            log.info((Object)("---- > UNPACKING " + this.getReportBytes().length));
            ByteArrayInputStream inBytes = new ByteArrayInputStream(this.getReportBytes());
            ZipInputStream zipIn = new ZipInputStream(inBytes);
            zipIn.getNextEntry();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtil.copyStream(zipIn, out);
            String report = out.toString();
            out.close();
            zipIn.closeEntry();
            zipIn.close();
            inBytes.close();
            log.info((Object)(" ---- > UNPACKED TO " + report.length()));
            return report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setReport(String report) {
        try {
            log.debug((Object)(" ---- > PACKING " + report.length()));
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(outBytes);
            zipOut.putNextEntry(new ZipEntry("report"));
            ByteArrayInputStream in = new ByteArrayInputStream(report.getBytes());
            IOUtil.copyStream(in, zipOut);
            zipOut.closeEntry();
            zipOut.close();
            outBytes.close();
            in.close();
            this.setReportBytes(outBytes.toByteArray());
            log.debug((Object)("---- > PACKED TO " + this.getReportBytes().length));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    @Column(name="theStart")
    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    @ManyToOne
    @JoinColumn(name="taskID")
    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    @Lob
    @Length(max=200000)
    public byte[] getReportBytes() {
        return this.reportBytes;
    }

    public void setReportBytes(byte[] reportBytes) {
        this.reportBytes = reportBytes;
    }
}

