/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.Validatable;
import com.bwanms.validation.WeakLength;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwTask")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class Task
implements Serializable,
Validatable {
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_STOPPING = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_DELETED = 3;
    public static final int RESULT_NEVER_RUN = 0;
    public static final int RESULT_FINISHED_OK = 1;
    public static final int RESULT_ABORTED = 2;
    public static final int RESULT_FAILED = 3;
    public static final int RESULT_FINISHED_WITH_ERRORS = 4;
    private static final Map<Integer, String> stateStrings = new HashMap<Integer, String>();
    private static final Map<Integer, String> resultStrings = new HashMap<Integer, String>();
    private long id;
    private String name;
    private String description;
    private String createdBy;
    private String modifiedBy;
    private int state = 0;
    private long lastRun = 0L;
    private int lastRunResult = 0;
    private TaskSchedule schedule;
    private List<TaskRunResult> taskRunResults;

    protected Task() {
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getLastRun() {
        return this.lastRun;
    }

    public void setLastRun(long lastRun) {
        this.lastRun = lastRun;
    }

    public int getLastRunResult() {
        return this.lastRunResult;
    }

    public void setLastRunResult(int lastRunResult) {
        this.lastRunResult = lastRunResult;
    }

    @WeakLength(min=1, max=128)
    @Pattern(regex="^([A-Za-z\\-_0-9\\$~`!@#&\\(\\)\\+=\\{\\}\\[\\]\\';\\.\\%]+ *)+$")
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @OneToOne(mappedBy="task", cascade={CascadeType.REMOVE})
    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(TaskSchedule schedule) {
        this.schedule = schedule;
    }

    public static String getStateString(int state) {
        return stateStrings.get(state);
    }

    public static String getLastResultString(int state) {
        return resultStrings.get(state);
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
    }

    public synchronized List<InvalidValue> performServerValidation() {
        return new ArrayList<InvalidValue>(0);
    }

    public abstract TaskExecutor createExecutor();

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="taskID")
    public List<TaskRunResult> getTaskRunResults() {
        return this.taskRunResults;
    }

    public void setTaskRunResults(List<TaskRunResult> taskRunResults) {
        this.taskRunResults = taskRunResults;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    static {
        stateStrings.put(0, "Inactive");
        stateStrings.put(1, "Stopping");
        stateStrings.put(2, "Active");
        stateStrings.put(3, "Deleted");
        resultStrings.put(0, "NeverRun");
        resultStrings.put(1, "Completed");
        resultStrings.put(2, "Aborted");
        resultStrings.put(3, "Failed");
        resultStrings.put(4, "CompletedWithErrors");
    }
}

