/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Identifiable;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.Service;
import com.bwanms.model.SubscriberEntry;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwSubscriber")
@org.hibernate.annotations.Table(name="BwSubscriber", indexes={@Index(name="IDX_SUBSCRIBER_ID", columnNames={"subscriberId"})})
public class Subscriber
extends ManagedEntityBase
implements Serializable,
Identifiable {
    public static final int ADMIN_STATUS_UNKNOWN = -1;
    public static final int ADMIN_STATUS_DISABLED = 0;
    public static final int ADMIN_STATUS_ENABLED = 1;
    public static final int ADMIN_STATUS_MIXED = 2;
    private String firstName;
    private String lastName;
    private String subscriberId;
    private String snmpDescription;
    private Set<Service> services;
    private String description;
    private String addressLine1;
    private String addressLine2;
    private String phoneNumber;
    private String mobileNumber;
    private String faxNumber;
    private String email;
    protected String complexKey;
    private List<SubscriberEntry> subscriberEntries;
    private List<SubscriberEntry> subscriberEntriesEnabled;

    @Length(max=50)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Length(max=50)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @OneToMany(mappedBy="subscriber")
    public Set<Service> getServices() {
        return this.services;
    }

    public void setServices(Set<Service> services) {
        this.services = services;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Length(min=1, max=32)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getSubscriberId() {
        return this.subscriberId;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    @Length(max=50)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getSnmpDescription() {
        return this.snmpDescription;
    }

    public void setSnmpDescription(String snmpDescription) {
        this.snmpDescription = snmpDescription;
    }

    public String getComplexKey() {
        return this.complexKey;
    }

    public void setComplexKey(String complexKey) {
        this.complexKey = complexKey;
    }

    @OneToMany
    @JoinColumn(name="complexKey", referencedColumnName="complexKey", insertable=false, updatable=false)
    public List<SubscriberEntry> getSubscriberEntries() {
        return this.subscriberEntries;
    }

    public void setSubscriberEntries(List<SubscriberEntry> subscriberEntries) {
        this.subscriberEntries = subscriberEntries;
    }

    public Integer getAdminStatusEnabled() {
        return 1;
    }

    public void setAdminStatusEnabled(Integer adminStatus) {
    }

    @OneToMany
    @JoinColumns(value={@JoinColumn(name="complexKey", referencedColumnName="complexKey", insertable=false, updatable=false), @JoinColumn(name="adminStatus", referencedColumnName="adminStatusEnabled", insertable=false, updatable=false)})
    public List<SubscriberEntry> getSubscriberEntriesEnabled() {
        return this.subscriberEntriesEnabled;
    }

    public void setSubscriberEntriesEnabled(List<SubscriberEntry> subscriberEntriesEnabled) {
        this.subscriberEntriesEnabled = subscriberEntriesEnabled;
    }
}

