/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.xsl.XMLUtil;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.NetworkScanMediationRequest;
import com.bwanms.mediation.ejb.NetworkScanSessionMessage;
import com.bwanms.model.AgentAuthentication;
import com.bwanms.model.Contact;
import com.bwanms.model.Contactable;
import com.bwanms.model.Equipment;
import com.bwanms.model.IPScanResult;
import com.bwanms.model.Locatable;
import com.bwanms.model.Location;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.SingleRangeScanTaskRuntimeStatus;
import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.Validatable;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.tasks.singlerangescan.SingleRangeScanTaskView;
import com.bwanms.util.DDPluginUtil;
import com.bwanms.util.InvalidNetworkMaskException;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.Settings;
import com.bwanms.validation.WeakRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwSingleRangeScanTask")
@PrimaryKeyJoinColumn(name="taskId")
public class SingleRangeScanTask
extends Task
implements Serializable,
Validatable,
Locatable,
Contactable {
    private static final long serialVersionUID = -2580641862840897863L;
    private static final transient Logger log = Logger.getLogger(SingleRangeScanTask.class);
    public static final int RANGE_TYPE_IP_RANGE = 1;
    public static final int RANGE_TYPE_SUBNET = 2;
    private Integer rangeType;
    private String rangeStart;
    private String rangeEnd;
    private Contact contact;
    private Location location;
    private Integer retries;
    private Long timeout;
    List<SNMPAgentAuthentication> communities;

    @Override
    public TaskExecutor createExecutor() {
        return new TaskExecutorImpl(this);
    }

    @Override
    @ManyToOne
    public Contact getContact() {
        return this.contact;
    }

    @Override
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @Override
    @ManyToOne
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Length(max=255)
    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(String rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    @Length(max=255)
    public String getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(String rangeStart) {
        this.rangeStart = rangeStart;
    }

    public Integer getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(Integer rangeType) {
        this.rangeType = rangeType;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="SNMPAgentAuthenticationId")
    public List<SNMPAgentAuthentication> getCommunities() {
        return this.communities;
    }

    public void setCommunities(List<SNMPAgentAuthentication> communities) {
        this.communities = communities;
    }

    @WeakRange(min=0L, max=255L)
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    @WeakRange(min=0L, max=3600L)
    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
        boolean validRange = true;
        super.validate(invalidValues);
        Internationalizer i18n = Internationalizer.getInternationalizer(SingleRangeScanTaskView.class);
        if (!this.rangeStart.matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpAddress"), SingleRangeScanTask.class, "rangeStart", (Object)this.notNull(this.rangeStart), (Object)this));
            validRange = false;
        }
        if (this.rangeType == 1 && !this.rangeEnd.matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpAddress"), SingleRangeScanTask.class, "rangeEnd", (Object)this.notNull(this.rangeEnd), (Object)this));
            validRange = false;
        }
        if (this.rangeType == 2 && !this.rangeEnd.matches("^255\\.255\\.255\\.(?:255|254|252|248|240|224|192|128|0)$|^255\\.255\\.(?:254|252|248|240|224|192|128|0)\\.0$|^255\\.(?:254|252|248|240|224|192|128|0)\\.0\\.0$|^(?:254|252|248|240|224|192|128|0)\\.0\\.0\\.0$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnet"), SingleRangeScanTask.class, "rangeEnd", (Object)this.notNull(this.rangeEnd), (Object)this));
            validRange = false;
        }
        if (this.communities == null || this.communities.size() == 0) {
            invalidValues.add(new InvalidValue(i18n.translateString("NoCommunities"), SingleRangeScanTask.class, "", (Object)"", (Object)this));
        } else if (this.communities.size() > 0) {
            int index = 0;
            for (SNMPAgentAuthentication community : this.communities) {
                ++index;
                if (community.getReadCommunity() == null || community.getReadCommunity().trim().equals("")) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidReadCommunity", index), SingleRangeScanTask.class, "", (Object)"", (Object)this));
                }
                if (community.getWriteCommunity() != null && !community.getWriteCommunity().trim().equals("")) continue;
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidWriteCommunity", index), SingleRangeScanTask.class, "", (Object)"", (Object)this));
            }
        }
        if (validRange && this.rangeType != null) {
            IpAddressRange ipRange = null;
            if (this.rangeType == 1) {
                IpAddress startAddr = new IpAddress(this.rangeStart);
                IpAddress endAddr = new IpAddress(this.rangeEnd);
                if (startAddr.compareTo(endAddr) > 0) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidEndAddress"), SingleRangeScanTask.class, "rangeEnd", (Object)this.notNull(this.rangeEnd), (Object)this));
                } else {
                    ipRange = new IpAddressRange(startAddr, endAddr);
                }
            } else {
                ipRange = this.getRange();
            }
            if (ipRange != null && (ipRange.size() < 0 || ipRange.size() > 65535)) {
                IpAddress rangeStartIpAddress = new IpAddress(this.getRangeStart());
                long maxIpAddressLong = new IpAddress("255.255.255.255").getIpAddress();
                long maxRangeIpAddressLong = rangeStartIpAddress.getIpAddress() + 65535L - 1L;
                IpAddress maxRangeIpAddress = new IpAddress(maxRangeIpAddressLong < maxIpAddressLong ? maxRangeIpAddressLong : maxIpAddressLong);
                invalidValues.add(new InvalidValue(i18n.translateString("RangeTooBig", rangeStartIpAddress.toString(), maxRangeIpAddress.toString()), SingleRangeScanTask.class, "", (Object)"", (Object)this));
            }
        }
    }

    private String notNull(String val) {
        return val != null ? val : "";
    }

    @Transient
    public IpAddressRange getRange() {
        IpAddressRange range;
        IpAddress start = new IpAddress(this.getRangeStart());
        IpAddress end = new IpAddress(this.getRangeEnd());
        if (this.getRangeType() == 1) {
            range = new IpAddressRange(start, end);
        } else {
            try {
                IpAddress temp = IpAddressRange.getSubnetStart(start, end).prevIpAddress();
                range = temp.getIpAddressType(this.getRangeEnd()) == IpAddress.IpAddressType.HOST ? new IpAddressRange(start, start) : IpAddressRange.fromSubnet(start, end);
            }
            catch (InvalidNetworkMaskException e) {
                throw new RuntimeException(e);
            }
        }
        return range;
    }

    private static class TaskExecutorImpl
    implements TaskExecutor,
    MessageListener {
        private static Internationalizer i18n = Internationalizer.getInternationalizer(SingleRangeScanTaskView.class);
        private transient TaskExecutionContext ctx = null;
        private SingleRangeScanTask task;
        private long sessionId;
        private StringBuffer scanResult;
        private IPScanResult[] results;
        private int nrScanned = 0;
        private int discovered = 0;

        public TaskExecutorImpl(SingleRangeScanTask task) {
            this.task = task;
            this.scanResult = new StringBuffer();
            this.scanResult.append(XMLUtil.beginReport(i18n.translateString("SingleRangeScanTask"), new Date()));
        }

        public void execute(TaskExecutionContext ctx) {
            this.ctx = ctx;
            IpAddressRange range = this.task.getRange();
            if (range.size() > 0) {
                NetworkScanMediationRequest req1 = new NetworkScanMediationRequest(range, new ArrayList<AgentAuthentication>(this.task.getCommunities()), this.task.getRetries(), this.task.getTimeout());
                this.results = new IPScanResult[range.size()];
                this.sessionId = MediationServiceRegistry.getNetworkScanMediationService().createSession();
                MediationServiceRegistry.getNetworkScanMediationService().addRequest(this.sessionId, req1);
                PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/NetworkScanMediationTopic", this);
                MediationServiceRegistry.getNetworkScanMediationService().startSession(this.sessionId);
            } else {
                this.scanResult.append(XMLUtil.endReport());
                ctx.taskFinished();
            }
        }

        public void onMessage(Message message) {
            block19: {
                IPScanResult ipScanResult = new IPScanResult();
                try {
                    NetworkScanSessionMessage result = (NetworkScanSessionMessage)((ObjectMessage)message).getObject();
                    if (result.getSessionId() != this.sessionId) {
                        return;
                    }
                    ipScanResult.setIpAddress(result.getIpAddress());
                    if (result.getStatus() == 3) {
                        String readCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getReadCommunity();
                        String writeCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getWriteCommunity();
                        log.debug((Object)("------------GOT RESULT:" + result.getSysName() + " " + result.getIpAddress() + ":" + result.getPort() + " ---- " + result.getSysObjID() + ", Read community:" + readCommunity + ", Write community:" + writeCommunity));
                        this.scanResult.append(XMLUtil.addRow(result.getIpAddress(), result.getCredentials(), i18n.translateString("FoundDevice", result.getSysName(), result.getSysObjID())));
                        ipScanResult.setResult(IPScanResult.NOT_SUPPORTED_EQUIPMENT_FOUND);
                        ++this.discovered;
                        ipScanResult.setEqName(result.getSysName());
                        try {
                            String className = DDPluginUtil.getClassNameForOId(result.getSysObjID());
                            if (className != null) {
                                log.info((Object)(" ------------------------OID:" + result.getSysObjID() + " IS SUPPORTED WITH CLASS:" + className));
                                ipScanResult.setResult(IPScanResult.SUPPORTED_EQUIPMENT_FOUND);
                                Equipment equipment = DDRegistry.getInstance().createEquipment(new SNMPManagementInterface(result.getIpAddress(), Settings.instance().getSNMPSettingsDefaultPort(), readCommunity, writeCommunity, this.task.getRetries(), this.task.getTimeout()), DDPluginUtil.getClassNameForOId(result.getSysObjID()), result.getSysName());
                                try {
                                    equipment.setLocation(this.task.getLocation());
                                    equipment.setContact(this.task.getContact());
                                    ServiceRegistry.getEntityManagerService().save(equipment);
                                    log.info((Object)"++++++++++++++++++++++++++EQ CREATED++++++++++++++++++++++++++");
                                }
                                catch (EntityAlreadyExistsException e) {
                                    log.info((Object)"++++++++++++++++EQ WAS ALREADY DISCOVERED+++++++++++");
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.results[this.nrScanned++] = ipScanResult;
                        if (this.ctx.shouldAbort()) {
                            MediationServiceRegistry.getNetworkScanMediationService().abortSession(this.sessionId);
                        }
                        break block19;
                    }
                    if (result.getStatus() == 5) {
                        log.debug((Object)("------------NO DEVICE AT : " + result.getIpAddress() + "---------------"));
                        this.scanResult.append(XMLUtil.addRow(result.getIpAddress(), result.getCredentials(), i18n.translateString("NoDeviceFound")));
                        ipScanResult.setResult(IPScanResult.NO_DEVICE_FOUND);
                        this.results[this.nrScanned++] = ipScanResult;
                        if (this.ctx.shouldAbort()) {
                            MediationServiceRegistry.getNetworkScanMediationService().abortSession(this.sessionId);
                        }
                    } else if (result.getStatus() == 1) {
                        log.debug((Object)"------------SESSION CLOSED MESSAGE RECEIVED---------------");
                        this.scanResult.append(XMLUtil.addValue("scanned", String.valueOf(this.nrScanned)));
                        this.scanResult.append(XMLUtil.addValue("discovered", String.valueOf(this.discovered)));
                        this.scanResult.append(XMLUtil.endReport());
                        System.out.println(this.scanResult.toString());
                        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this);
                        this.ctx.taskFinished();
                    } else if (result.getStatus() == 2) {
                        log.debug((Object)"------------SESSION ABORTED MESSAGE RECEIVED---------------");
                        this.scanResult.append(XMLUtil.endReport());
                        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this);
                        this.ctx.taskFinished();
                    } else if (result.getStatus() == 4) {
                        log.debug((Object)"------------REQUEST COMPLETED MESSAGE RECEIVED---------------");
                        MediationServiceRegistry.getNetworkScanMediationService().closeSession(this.sessionId);
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        public TaskRuntimeStatus getStatus(Object clientData) {
            SingleRangeScanTaskRuntimeStatus runtimeStatus = new SingleRangeScanTaskRuntimeStatus();
            Integer index = (Integer)clientData;
            ArrayList<IPScanResult> tempList = new ArrayList<IPScanResult>();
            int i = 0;
            if (index != null) {
                i = index;
            }
            while (i < this.nrScanned) {
                tempList.add(this.results[i]);
                ++i;
            }
            runtimeStatus.setResults(tempList);
            runtimeStatus.setOverallPercentage(this.nrScanned * 100 / this.results.length);
            return runtimeStatus;
        }

        public String getReport() {
            return this.scanResult.toString();
        }

        public int getExecutionResult() {
            if (this.ctx.shouldAbort()) {
                return 2;
            }
            return 1;
        }
    }
}

