/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.meta.settings.SettingsKey;
import com.bwanms.model.SettingsItem;
import com.bwanms.util.BeanUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwSettings", uniqueConstraints={@UniqueConstraint(columnNames={"owner"})})
public class Settings
implements Serializable {
    private long id;
    private String owner;
    private Map<String, SettingsItem> items;

    @Id(generate=GeneratorType.AUTO)
    long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    @OneToMany(mappedBy="settings", cascade={CascadeType.ALL})
    @MapKey(name="itemKey")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    Map<String, SettingsItem> getItems() {
        if (null == this.items) {
            this.items = new HashMap<String, SettingsItem>();
        }
        return this.items;
    }

    void setItems(Map<String, SettingsItem> items) {
        this.items = items;
    }

    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Transient
    public String getProperty(String key, String defaultValue) {
        SettingsItem item = this.getItems().get(key);
        if (item == null) {
            return defaultValue;
        }
        return item.getItemValue();
    }

    public void setProperty(String key, String value) {
        SettingsItem item = this.getItems().get(key);
        if (item == null) {
            item = new SettingsItem(key);
            item.setSettings(this);
            this.getItems().put(key, item);
        }
        item.setItemValue(value);
    }

    public void removeProperty(String key) {
        this.getItems().remove(key);
    }

    public <T> T read(Class<T> objectClass) {
        try {
            T ret = objectClass.newInstance();
            for (Method getter : BeanUtils.getPropertyGetters(objectClass)) {
                SettingsKey anno = getter.getAnnotation(SettingsKey.class);
                if (anno == null) continue;
                String value = this.getProperty(anno.key(), anno.defaultValue());
                String propName = BeanUtils.getPropertyNameFromGetter(getter);
                Class<?> retType = getter.getReturnType();
                if (String.class.isAssignableFrom(retType)) {
                    BeanUtils.setPropertyValue(ret, propName, value);
                    continue;
                }
                if (Integer.class.isAssignableFrom(retType)) {
                    BeanUtils.setPropertyValue(ret, propName, new Integer(value));
                    continue;
                }
                if (Long.class.isAssignableFrom(retType)) {
                    BeanUtils.setPropertyValue(ret, propName, new Long(value));
                    continue;
                }
                if (!Boolean.class.isAssignableFrom(retType)) continue;
                BeanUtils.setPropertyValue(ret, propName, new Boolean(value));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Object object) {
        try {
            for (Method getter : BeanUtils.getPropertyGetters(object.getClass())) {
                SettingsKey anno = getter.getAnnotation(SettingsKey.class);
                if (anno == null) continue;
                Object value = BeanUtils.getPropertyValue(object, BeanUtils.getPropertyNameFromGetter(getter));
                this.setProperty(anno.key(), value.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

