/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import org.hibernate.Hibernate;

public final class ObjectID
implements Serializable {
    private static final long serialVersionUID = 9181144675323585366L;
    private String className;
    private Serializable identifier;

    public ObjectID(Object entity) {
        this.className = Hibernate.getClass((Object)entity).getName();
        this.identifier = Datastore.session().getIdentifier(entity);
    }

    public ObjectID(String className, Serializable identifier) {
        this.className = className;
        this.identifier = identifier;
    }

    public String getClassName() {
        return this.className;
    }

    public Serializable getIdentifier() {
        return this.identifier;
    }

    public static Object getEntity(ObjectID oid) {
        return Datastore.session().get(oid.className, oid.identifier);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectID)) {
            return false;
        }
        ObjectID oid = (ObjectID)obj;
        return this.className.equals(oid.className) && this.identifier.equals(oid.identifier);
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.identifier.hashCode();
    }

    public String toString() {
        return this.className + "#" + this.identifier.toString();
    }
}

