/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.domain.logic.ManagedNetworkHelper;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.xsl.XMLUtil;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.NetworkScanMediationRequest;
import com.bwanms.mediation.ejb.NetworkScanSessionMessage;
import com.bwanms.model.AgentAuthentication;
import com.bwanms.model.Equipment;
import com.bwanms.model.IPScanResult;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.NetworkSNMPCommunity;
import com.bwanms.model.NetworkScanTaskRuntimeRanges;
import com.bwanms.model.NetworkScanTaskRuntimeStatus;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.SystemTask;
import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.DDPluginUtil;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwNetworkScanTask")
public class NetworkScanTask
extends Task
implements SystemTask {
    private static final long serialVersionUID = 3906410600257298231L;
    private static Logger log = Logger.getLogger(NetworkScanTask.class);
    private Integer retries;
    private Long timeout;
    private List<NetworkIpAddressRange> ranges = new ArrayList<NetworkIpAddressRange>();

    @Override
    public TaskExecutor createExecutor() {
        return new TaskExecutorImpl(this);
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Transient
    public List<NetworkIpAddressRange> getRanges() {
        return this.ranges;
    }

    private static class TaskExecutorImpl
    implements TaskExecutor,
    MessageListener {
        private transient TaskExecutionContext ctx;
        private NetworkScanTask task;
        private long sessionId;
        private Map<Integer, IPScanResult[]> results;
        private Map<Integer, NetworkIpAddressRange> userRanges;
        private Map<Integer, Integer> resultsCounters;
        private int requestsCounter;
        private int key = 0;
        private boolean taskFailed;

        public TaskExecutorImpl(NetworkScanTask task) {
            this.task = task;
            this.results = new HashMap<Integer, IPScanResult[]>();
            this.resultsCounters = new HashMap<Integer, Integer>();
            this.userRanges = new HashMap<Integer, NetworkIpAddressRange>();
            this.taskFailed = false;
        }

        public void execute(TaskExecutionContext ctx) {
            this.ctx = ctx;
            this.sessionId = MediationServiceRegistry.getNetworkScanMediationService().createSession();
            final ArrayList ranges = new ArrayList();
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    ranges.addAll(ManagedNetworkHelper.getRangesForDiscovery());
                }
            }).run();
            List<NetworkSNMPCommunity> globalCommunities = ServiceRegistry.getEntityManagerService().retrieveAll(NetworkSNMPCommunity.class);
            if (ranges.size() > 0) {
                for (NetworkIpAddressRange range : ranges) {
                    int userId = new Long(range.getId()).intValue();
                    ++this.key;
                    IpAddressRange ipRange = range.toIpAddressRange();
                    ArrayList<NetworkSNMPCommunity> communities = new ArrayList<NetworkSNMPCommunity>();
                    communities.add(new NetworkSNMPCommunity(range.getReadCommunity(), range.getWriteCommunity()));
                    communities.addAll(globalCommunities);
                    log.debug((Object)("-NETWORK SCAN TASK-submitting for scanning range " + range.getStartIp() + " ... " + range.getEndIp() + "  ( " + this.task.getRetries() + " retries, " + this.task.getTimeout() + " )"));
                    NetworkScanMediationRequest req = new NetworkScanMediationRequest(ipRange, new ArrayList<AgentAuthentication>(communities), this.task.getRetries(), this.task.getTimeout(), userId);
                    MediationServiceRegistry.getNetworkScanMediationService().addRequest(this.sessionId, req);
                    this.results.put(userId, new IPScanResult[ipRange.size()]);
                    this.userRanges.put(userId, range);
                    this.resultsCounters.put(userId, 0);
                }
                this.requestsCounter = ranges.size();
                log.debug((Object)("-NETWORK SCAN TASK-" + this.requestsCounter + " ranges submitted for scanning "));
                PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/NetworkScanMediationTopic", this);
                MediationServiceRegistry.getNetworkScanMediationService().startSession(this.sessionId);
            } else {
                this.taskFailed = true;
                ctx.taskFinished();
            }
        }

        public synchronized TaskRuntimeStatus getStatus(Object clientData) {
            if (clientData != null) {
                NetworkScanTaskRuntimeStatus runtimeStatus = new NetworkScanTaskRuntimeStatus();
                Integer userId = (Integer)clientData;
                ArrayList<IPScanResult> tempList = new ArrayList<IPScanResult>();
                int nrScanned = this.resultsCounters.get(userId);
                IPScanResult[] tempResults = this.results.get(userId);
                for (int i = 0; i < nrScanned; ++i) {
                    tempList.add(tempResults[i]);
                }
                runtimeStatus.setResults(tempList);
                runtimeStatus.setOverallPercentage(nrScanned * 100 / tempResults.length);
                runtimeStatus.setUserId(userId);
                return runtimeStatus;
            }
            log.info((Object)" ------------------ SENDING RANGES TO CLIENT");
            NetworkScanTaskRuntimeRanges runtimeRanges = new NetworkScanTaskRuntimeRanges();
            ArrayList<NetworkIpAddressRange> temp = new ArrayList<NetworkIpAddressRange>();
            temp.addAll(this.userRanges.values());
            runtimeRanges.setRanges(temp);
            return runtimeRanges;
        }

        public String getReport() {
            Internationalizer i18n = Internationalizer.getInternationalizer(NetworkScanTask.class);
            String report = XMLUtil.createReportForNetworkTask(i18n.translateString("NetworkScanTaskReport"), this.userRanges, this.results, this.task);
            return report;
        }

        public void onMessage(Message message) {
            block20: {
                IPScanResult ipScanResult = new IPScanResult();
                try {
                    NetworkScanSessionMessage result = (NetworkScanSessionMessage)((ObjectMessage)message).getObject();
                    if (result.getSessionId() != this.sessionId) {
                        return;
                    }
                    ipScanResult.setIpAddress(result.getIpAddress());
                    if (result.getStatus() == 3) {
                        String readCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getReadCommunity();
                        String writeCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getWriteCommunity();
                        log.debug((Object)("------------GOT RESULT:" + result.getSysName() + " " + result.getIpAddress() + ":" + result.getPort() + " ---- " + result.getSysObjID() + ", Read community:" + readCommunity + ", Write community:" + writeCommunity));
                        ipScanResult.setResult(IPScanResult.NOT_SUPPORTED_EQUIPMENT_FOUND);
                        ipScanResult.setReadCommunity(readCommunity);
                        ipScanResult.setWriteCommunity(writeCommunity);
                        ipScanResult.setOID(result.getSysObjID());
                        ipScanResult.setEqName(result.getSysName());
                        try {
                            String className = DDPluginUtil.getClassNameForOId(result.getSysObjID());
                            if (className != null) {
                                log.info((Object)(" ------------------------OID:" + result.getSysObjID() + " IS SUPPORTED WITH CLASS:" + className));
                                ipScanResult.setResult(IPScanResult.SUPPORTED_EQUIPMENT_FOUND);
                                Equipment equipment = DDRegistry.getInstance().createEquipment(new SNMPManagementInterface(result.getIpAddress(), Settings.instance().getSNMPSettingsDefaultPort(), readCommunity, writeCommunity, this.task.getRetries(), this.task.getTimeout()), DDPluginUtil.getClassNameForOId(result.getSysObjID()), result.getSysName());
                                try {
                                    equipment.setLocation(this.userRanges.get(result.getRequest().getUserId()).getLocation());
                                    ServiceRegistry.getEntityManagerService().save(equipment);
                                    log.info((Object)"++++++++++++++++++++++++++EQ CREATED++++++++++++++++++++++++++");
                                }
                                catch (EntityAlreadyExistsException e) {
                                    log.info((Object)"++++++++++++++++EQ WAS ALREADY DISCOVERED+++++++++++");
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.addIpScanResult(ipScanResult, result);
                        if (this.ctx.shouldAbort()) {
                            MediationServiceRegistry.getNetworkScanMediationService().abortSession(this.sessionId);
                        }
                        break block20;
                    }
                    if (result.getStatus() == 5) {
                        log.debug((Object)("------------NO DEVICE AT : " + result.getIpAddress() + "---------------"));
                        ipScanResult.setResult(IPScanResult.NO_DEVICE_FOUND);
                        this.addIpScanResult(ipScanResult, result);
                        if (this.ctx.shouldAbort()) {
                            MediationServiceRegistry.getNetworkScanMediationService().abortSession(this.sessionId);
                        }
                    } else if (result.getStatus() == 1) {
                        log.debug((Object)"------------SESSION CLOSED MESSAGE RECEIVED---------------");
                        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this);
                        this.ctx.taskFinished();
                    } else if (result.getStatus() == 2) {
                        log.debug((Object)"------------SESSION ABORTED MESSAGE RECEIVED---------------");
                        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this);
                        this.ctx.taskFinished();
                    } else if (result.getStatus() == 4) {
                        log.debug((Object)"------------REQUEST COMPLETED MESSAGE RECEIVED---------------");
                        if (this.allRequestsCompleted()) {
                            MediationServiceRegistry.getNetworkScanMediationService().closeSession(this.sessionId);
                        }
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        private void addIpScanResult(IPScanResult ipScanResult, NetworkScanSessionMessage result) {
            Integer userId = result.getRequest().getUserId();
            int counter = this.resultsCounters.get(userId);
            this.results.get((Object)userId)[counter] = ipScanResult;
            this.resultsCounters.put(userId, ++counter);
        }

        private synchronized boolean allRequestsCompleted() {
            return --this.requestsCounter <= 0;
        }

        public int getExecutionResult() {
            if (this.ctx.shouldAbort()) {
                return 2;
            }
            if (this.taskFailed) {
                return 3;
            }
            return 1;
        }
    }
}

