/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Locatable;
import com.bwanms.model.Location;
import com.bwanms.util.InvalidNetworkMaskException;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="BwNetworkIpAddressRange")
public class NetworkIpAddressRange
implements Serializable,
Locatable {
    private long id;
    private Integer type;
    private String startIp;
    private String endIp;
    private Boolean enableDiscovery;
    private Boolean enableAutoDiscovery;
    private String readCommunity;
    private String writeCommunity;
    private Location location;
    public static final int RANGE_TYPE_IP_RANGE = 0;
    public static final int RANGE_TYPE_SUBNET = 1;
    public static final String FILE_EXTENSION = "nar";
    public static final int MAX_RANGE_SIZE = 65535;
    private static String[] typeString = new String[]{"IpRange", "Subnet"};

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Boolean getEnableAutoDiscovery() {
        return this.enableAutoDiscovery;
    }

    public void setEnableAutoDiscovery(Boolean enableAutoDiscovery) {
        this.enableAutoDiscovery = enableAutoDiscovery;
    }

    public Boolean getEnableDiscovery() {
        return this.enableDiscovery;
    }

    public void setEnableDiscovery(Boolean enableDiscovery) {
        this.enableDiscovery = enableDiscovery;
    }

    public String getEndIp() {
        return this.endIp;
    }

    public void setEndIp(String endIp) {
        this.endIp = endIp;
    }

    public String getReadCommunity() {
        return this.readCommunity;
    }

    public void setReadCommunity(String readCommunity) {
        this.readCommunity = readCommunity;
    }

    public String getStartIp() {
        return this.startIp;
    }

    public void setStartIp(String startIp) {
        this.startIp = startIp;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public void setWriteCommunity(String writeCommunity) {
        this.writeCommunity = writeCommunity;
    }

    @ManyToOne
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public static String toStringType(int type) {
        if (type > typeString.length) {
            return "notSupported";
        }
        return typeString[type];
    }

    public IpAddressRange toIpAddressRange() {
        IpAddressRange ipRange;
        IpAddress start = new IpAddress(this.getStartIp());
        IpAddress end = new IpAddress(this.getEndIp());
        if (this.getType() == 0) {
            ipRange = new IpAddressRange(start, end);
        } else {
            try {
                IpAddress temp = IpAddressRange.getSubnetStart(start, end).prevIpAddress();
                ipRange = temp.getIpAddressType(this.getEndIp()) == IpAddress.IpAddressType.HOST ? new IpAddressRange(start, start) : IpAddressRange.fromSubnet(start, end);
            }
            catch (InvalidNetworkMaskException e) {
                throw new RuntimeException(e);
            }
        }
        return ipRange;
    }
}

