/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Equipment;
import com.bwanms.model.MultipleConfigWeakAssociation;
import com.bwanms.model.Task;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwMultipleConfigTask")
public abstract class MultipleConfigTask
extends Task {
    protected List<MultipleConfigWeakAssociation> managedEntityWeakAssociation;

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="BwMultipleConfigTask_WAssoc"), inverseJoinColumns={@JoinColumn(name="mewa_id")})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<MultipleConfigWeakAssociation> getManagedEntityWeakAssociation() {
        if (null == this.managedEntityWeakAssociation) {
            this.managedEntityWeakAssociation = new ArrayList<MultipleConfigWeakAssociation>();
        }
        return this.managedEntityWeakAssociation;
    }

    public void setManagedEntityWeakAssociation(List<MultipleConfigWeakAssociation> managedEntityWeakAssociation) {
        this.managedEntityWeakAssociation = managedEntityWeakAssociation;
    }

    @Transient
    public List<Equipment> getEquipments() {
        ArrayList<Equipment> tempListEquipment = new ArrayList<Equipment>();
        if (this.getManagedEntityWeakAssociation().size() > 0) {
            for (MultipleConfigWeakAssociation assoc : this.getManagedEntityWeakAssociation()) {
                Equipment eq = (Equipment)assoc.getEntity();
                tempListEquipment.add(eq);
            }
        }
        return tempListEquipment;
    }

    @Transient
    public void setEquipments(List<Equipment> baseStations) {
        this.getManagedEntityWeakAssociation().clear();
        for (Equipment bs : baseStations) {
            this.getManagedEntityWeakAssociation().add(new MultipleConfigWeakAssociation(bs, true));
        }
    }
}

