/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Identifiable;
import com.bwanms.model.Location;
import com.bwanms.model.LocationMapNodePosition;
import com.bwanms.model.ObjectID;
import com.bwanms.model.Validatable;
import com.bwanms.validation.AbsoluteFilePath;
import com.bwanms.validation.FileExists;
import com.bwanms.validation.MaxFileLength;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.LobType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwLocationMap")
public class LocationMap
implements Serializable,
Validatable,
Identifiable {
    private long id;
    private String origFilename;
    private byte[] imgData;
    private Location location;
    private Collection<LocationMapNodePosition> nodePosition;
    public static final int MAXIMUM_BACKGROUND_SIZE = 524288;
    private String display;

    @Override
    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Lob(type=LobType.BLOB, fetch=FetchType.LAZY)
    @Length(max=524288)
    public byte[] getImgData() {
        return this.imgData;
    }

    public void setImgData(byte[] imgData) {
        this.imgData = imgData;
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
    }

    @AbsoluteFilePath
    @FileExists(isDirectory=false, checkOnlyIfAbsolutePath=true)
    @MaxFileLength(value=65535L)
    public String getOrigFilename() {
        return this.origFilename;
    }

    public void setOrigFilename(String origFilename) {
        this.origFilename = origFilename;
    }

    @ManyToOne
    @JoinColumn(name="location_id")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="locationMap", fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Collection<LocationMapNodePosition> getNodePosition() {
        return this.nodePosition;
    }

    @Transient
    public Map<ObjectID, LocationMapNodePosition> getAsocNodePosition() {
        HashMap<ObjectID, LocationMapNodePosition> map = new HashMap<ObjectID, LocationMapNodePosition>();
        for (LocationMapNodePosition nodePos : this.nodePosition) {
            map.put(nodePos.getObjectID(), nodePos);
        }
        return map;
    }

    public void setNodePosition(Collection<LocationMapNodePosition> nodePosition) {
        this.nodePosition = nodePosition;
    }

    @Transient
    public boolean hasImageAssigned() {
        return this.imgData != null && this.imgData.length > 0;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }
}

