/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.locationmanager.LocationView;
import com.bwanms.model.AlarmStateCompute;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.model.Locatable;
import com.bwanms.model.LocationMap;
import com.bwanms.model.SimpleAlarmState;
import com.bwanms.model.Validatable;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwLocation")
public class Location
implements Serializable,
Validatable,
Identifiable,
AlarmStateCompute {
    public static final String COL_ID = "Id";
    private static final long serialVersionUID = 8188623734748854637L;
    private long id;
    private String name;
    private Location parent;
    private Set<Location> children;
    private int coordinateType;
    private String coordinates;
    private String iconName;
    private String topologyImageName;
    private String postalAddress;
    private String details;
    private double area;
    private SimpleAlarmState simpleAlarmState;
    private List<LocationMap> locationMap;
    public static final int LOCATION_TYPE_OTHER = 0;
    public static final int LOCATION_TYPE_CUSTOMER = 1;
    public static final int LOCATION_TYPE_PROVIDER = 2;
    public static final int COORDINATE_TYPE_LATLONG = 0;
    public static final int COORDINATE_TYPE_VH = 1;
    public static final int COORDINATE_TYPE_NPANXX = 2;
    public static final int COORDINATE_TYPE_CTRYCTY = 3;
    private static final String[] locationTypeStrings = new String[]{"other", "customer", "provider"};
    private static final String[] coordinateTypeStrings = new String[]{"Lat_Long", "V_H", "NPA_NXX", "Country_City"};

    @Override
    @Id(generate=GeneratorType.AUTO)
    @Column(name="Id")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="parent_fk")
    public Set<Location> getChildren() {
        if (this.children == null) {
            this.children = new HashSet<Location>();
        }
        return this.children;
    }

    public void setChildren(Set<Location> children) {
        this.children = children;
    }

    @Length(min=0, max=80)
    public String getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public int getCoordinateType() {
        return this.coordinateType;
    }

    public void setCoordinateType(int coordinateType) {
        this.coordinateType = coordinateType;
    }

    @Length(min=0, max=80)
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @Length(min=0, max=80)
    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    @Length(min=0, max=80)
    public String getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
    }

    @Length(min=0, max=80)
    public String getTopologyImageName() {
        return this.topologyImageName;
    }

    public void setTopologyImageName(String topologyImageName) {
        this.topologyImageName = topologyImageName;
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
    }

    @ManyToOne
    @JoinColumn(name="parent_fk")
    public Location getParent() {
        return this.parent;
    }

    public void setParent(Location parent) {
        this.parent = parent;
    }

    public static String toStringLocationType(int type) {
        try {
            return locationTypeStrings[type];
        }
        catch (IndexOutOfBoundsException ex) {
            return "not_supported";
        }
    }

    public static String toStringCoordinateType(int type) {
        try {
            return coordinateTypeStrings[type];
        }
        catch (IndexOutOfBoundsException ex) {
            return "not_supported";
        }
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(LocationView.class);
        if (this.name == null || this.name.trim().equals("") || this.name.length() < 1 || this.name.length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("invalidName"), Location.class, "name", (Object)this.name, (Object)this));
        }
    }

    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public SimpleAlarmState getSimpleAlarmState() {
        if (this.simpleAlarmState == null) {
            this.simpleAlarmState = new SimpleAlarmState();
        }
        return this.simpleAlarmState;
    }

    public void setSimpleAlarmState(SimpleAlarmState simpleAlarmState) {
        this.simpleAlarmState = simpleAlarmState;
    }

    @Override
    @Transient
    public int getAlarmState() {
        return this.getSimpleAlarmState().getAlarmState();
    }

    @Override
    public void computeAlarmState() {
        int maxAlarmState = Severity.Other.value();
        for (Location child : this.getChildren()) {
            if (child.getAlarmState() > maxAlarmState) {
                maxAlarmState = child.getAlarmState();
            }
            if (maxAlarmState != Severity.Critical.value()) continue;
            break;
        }
        boolean hasEquipments = false;
        if (maxAlarmState != Severity.Critical.value()) {
            List locatables = Datastore.session().createQuery("from " + Locatable.class.getName() + " as l where l.location=:location").setEntity("location", (Object)this).list();
            for (Locatable locatable : locatables) {
                if (!(locatable instanceof Equipment)) continue;
                hasEquipments = true;
                Equipment eq = (Equipment)locatable;
                if (eq.getState() == -1 || eq.getState() == 1) {
                    maxAlarmState = Severity.Critical.value();
                    break;
                }
                if (eq.getAlarmState() <= maxAlarmState) continue;
                maxAlarmState = eq.getAlarmState();
            }
        }
        if (hasEquipments && maxAlarmState < Severity.Cleared.value()) {
            maxAlarmState = Severity.Cleared.value();
        }
        this.getSimpleAlarmState().setAlarmState(maxAlarmState);
    }

    public Location findLocation(long id) {
        if (this.id == id) {
            return this;
        }
        for (Location child : this.getChildren()) {
            Location loc = child.findLocation(id);
            if (loc == null) continue;
            return loc;
        }
        return null;
    }

    @Transient
    public LocationMap getSingleLocationMap() {
        if (this.getLocationMap().isEmpty()) {
            LocationMap nLocationMap = new LocationMap();
            this.locationMap.add(0, nLocationMap);
        }
        return this.locationMap.get(0);
    }

    @Transient
    public void setSingleLocationMap(LocationMap nLocationMap) {
        this.getLocationMap().clear();
        this.getLocationMap().add(0, nLocationMap);
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="location", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<LocationMap> getLocationMap() {
        if (this.locationMap == null) {
            this.locationMap = new ArrayList<LocationMap>();
        }
        return this.locationMap;
    }

    public void setLocationMap(List<LocationMap> locationMap) {
        this.locationMap = locationMap;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return this.id == other.id;
    }
}

