/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.model.AlarmState;
import com.bwanms.model.Contact;
import com.bwanms.model.Contactable;
import com.bwanms.model.Locatable;
import com.bwanms.model.Location;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.Validatable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Table(name="BwEquipment")
public abstract class Equipment
extends ManagedEntityBase
implements Serializable,
Cloneable,
Locatable,
Contactable,
Validatable,
AlarmState {
    public static final String TABLE_NAME = "BwEquipment";
    private String model;
    private String EUID;
    private String firmwareVersion;
    private String hardwareRevision;
    private Long ipAddr;
    private Map<String, EquipmentConfiguration> configurations;
    private Location location;
    private Contact contact;
    public static final String CONFIG_CURRENT = "current";
    public static final String CONFIG_PHYSICAL = "physical";
    private int lastKnownState = -3;
    private String runningSoftwareVersion;
    private String hardwareVersion;
    private int alarmState;
    private String serialNumber;

    @Override
    public int getAlarmState() {
        return this.alarmState;
    }

    public void setAlarmState(int alarmState) {
        this.alarmState = alarmState;
    }

    public Equipment() {
        super.setState(-3);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getEUID() {
        return this.EUID;
    }

    public void setEUID(String euid) {
        this.EUID = euid;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public Long getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(Long ipAddr) {
        this.ipAddr = ipAddr;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("id=").append(this.getId()).append(", ");
        result.append("euid=").append(this.EUID).append(", ");
        result.append("name=").append(this.getName()).append(", ");
        result.append("model=").append(this.model).append(", ");
        result.append("softwareversion=").append(this.firmwareVersion).append(", ");
        result.append("]");
        return result.toString();
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="equipment")
    @Basic(fetch=FetchType.LAZY)
    @MapKey(name="name")
    public Map<String, EquipmentConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, EquipmentConfiguration> configurations) {
        this.configurations = configurations;
    }

    public EquipmentConfiguration findCurrentConfiguration() {
        EquipmentConfiguration ret = this.getConfigurations().get(CONFIG_CURRENT);
        if (ret == null) {
            throw new RuntimeException("No Current Configuration found");
        }
        return ret;
    }

    public void setCurrentConfiguration(EquipmentConfiguration configuration) {
        configuration.setName(CONFIG_CURRENT);
        Map<String, EquipmentConfiguration> configurations = this.getConfigurations();
        if (configurations == null) {
            configurations = new HashMap<String, EquipmentConfiguration>();
            this.setConfigurations(configurations);
        }
        this.getConfigurations().put(CONFIG_CURRENT, configuration);
    }

    @Transient
    public boolean isReachable() {
        int state = this.getState();
        return state != -1 && state != -3;
    }

    @Override
    @ManyToOne
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    @ManyToOne
    public Contact getContact() {
        return this.contact;
    }

    @Override
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public static final String getSynchronizationLockKey(long equipmentId) {
        return "Equipment#" + equipmentId + "#synchronization";
    }

    public static final String getConfigurationLockKey(long equipmentId) {
        return "Equipment#" + equipmentId + "#configuration";
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(Equipment.class);
        if (this.getName() == null || this.getName().trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), SNMPManagementInterface.class, "name", (Object)"", (Object)this));
        }
    }

    public String getHardwareRevision() {
        return this.hardwareRevision;
    }

    public void setHardwareRevision(String hardwareRevision) {
        this.hardwareRevision = hardwareRevision;
    }

    public String getHardwareVersion() {
        return this.hardwareVersion;
    }

    public void setHardwareVersion(String hardwareVersion) {
        this.hardwareVersion = hardwareVersion;
    }

    public String getRunningSoftwareVersion() {
        return this.runningSoftwareVersion;
    }

    public void setRunningSoftwareVersion(String runningSoftwareVersion) {
        this.runningSoftwareVersion = runningSoftwareVersion;
    }

    @Override
    public void setState(int state) {
        this.setLastKnownState(this.getState());
        super.setState(state);
    }

    public void restoreLastKnownState() {
        super.setState(this.lastKnownState);
    }

    public int getLastKnownState() {
        return this.lastKnownState;
    }

    private void setLastKnownState(int lastKnownState) {
        this.lastKnownState = lastKnownState;
    }

    @Override
    @Transient
    public String getManagedObjectId() {
        return this.getEUID();
    }

    @Transient
    public abstract int getMOType();

    @Transient
    public abstract String getMOInstance();
}

