/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.EqTreeNodeValue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class EqTreeNode
implements TreeNode {
    private EqTreeNode parent;
    private List<EqTreeNode> children;
    private EqTreeNodeValue value;

    public EqTreeNode() {
        this.children = new ArrayList<EqTreeNode>();
    }

    public EqTreeNode(EqTreeNode parent, EqTreeNodeValue value) {
        this.parent = parent;
        this.value = value;
        this.children = new ArrayList<EqTreeNode>();
        for (EqTreeNodeValue val : value.getChildren()) {
            this.addChild(new EqTreeNode(this, val));
        }
    }

    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    public TreeNode removeChildAt(int childIndex) {
        EqTreeNode child = this.children.remove(childIndex);
        child.parent = null;
        return child;
    }

    public boolean removeChild(EqTreeNode child) {
        return this.children.remove(child);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public Enumeration children() {
        return new Vector<EqTreeNode>(this.children).elements();
    }

    public EqTreeNodeValue getValue() {
        return this.value;
    }

    public void setValue(EqTreeNodeValue value) {
        this.value = value;
    }

    public void addChild(EqTreeNode child) {
        if (child != null) {
            this.children.add(child);
        }
    }
}

