/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model;

import com.bwanms.model.Identifiable;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@Entity
@Table(name="BwContact")
public class Contact
implements Serializable,
Cloneable,
Identifiable {
    public static final String TABLE_NAME = "BwContact";
    public static final String COL_ID = "Id";
    private long id;
    private String contactId;
    private String firstName;
    private String lastName;
    private String company;
    private String address;
    private String phoneNumber;
    private String email;
    private String mobileNumber;
    private String faxNumber;
    private String iconName;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Length(min=0, max=80)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String name) {
        this.firstName = name;
    }

    @Length(min=0, max=80)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Length(min=0, max=80)
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @Pattern(regex="^[.]{0}$||^[\\p{Alnum}\\.\\-\\_]+\\@[\\p{Alnum}\\.\\-\\_]+\\.[a-z]+$", message="{validator.email}")
    @Length(min=0, max=80)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Length(min=0, max=80)
    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @Length(min=0, max=80)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Length(min=0, max=80)
    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @Length(min=0, max=80)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Pattern(regex="^.*\\S$")
    @Length(min=1, max=80)
    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    @Length(min=0, max=80)
    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contact other = (Contact)obj;
        return this.id == other.id;
    }
}

