/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo.common;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@EmbeddableSuperclass
public class SystemGroup
extends ScalarMO {
    private static final long serialVersionUID = 753394330350301393L;
    private long id;
    private String systemObjectID;
    private String systemDescription;
    private Long systemUpTime;
    private String systemContact;
    private String systemName;
    private String systemLocation;
    private Integer systemServices;
    private NetworkResourceConfiguration networkResourceConfiguration;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.2.1.1.1", type=-128, readOnly=true)
    @ConfigAttribute
    public String getSystemDescription() {
        return this.systemDescription;
    }

    @SNMPParameter(OID="1.3.6.1.2.1.1.2", type=6, readOnly=true)
    @InventoryAttribute
    public String getSystemObjectID() {
        return this.systemObjectID;
    }

    @Length(min=0, max=255)
    @SNMPParameter(OID="1.3.6.1.2.1.1.4", type=-128)
    @ConfigAttribute
    public String getSystemContact() {
        return this.systemContact;
    }

    @Length(min=0, max=255)
    @SNMPParameter(OID="1.3.6.1.2.1.1.6", type=-128)
    @ConfigAttribute
    public String getSystemLocation() {
        return this.systemLocation;
    }

    @Length(min=0, max=255)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    @SNMPParameter(OID="1.3.6.1.2.1.1.5", type=-128)
    @ConfigAttribute
    public String getSystemName() {
        return this.systemName;
    }

    @SNMPParameter(OID="1.3.6.1.2.1.1.3", type=67, readOnly=true)
    @StateAttribute
    public Long getSystemUpTime() {
        return this.systemUpTime;
    }

    @SNMPParameter(OID="1.3.6.1.2.1.1.7", type=2, readOnly=true)
    @InventoryAttribute
    public Integer getSystemServices() {
        return this.systemServices;
    }

    public void setSystemObjectID(String systemObjectID) {
        this.systemObjectID = systemObjectID;
    }

    public void setSystemDescription(String systemDescription) {
        this.systemDescription = systemDescription;
    }

    public void setSystemContact(String systemContact) {
        this.systemContact = systemContact;
    }

    public void setSystemLocation(String systemLocation) {
        this.systemLocation = systemLocation;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setSystemServices(Integer systemServices) {
        this.systemServices = systemServices;
    }

    public void setSystemUpTime(Long systemUpTime) {
        this.systemUpTime = systemUpTime;
    }

    public void setNetworkResourceConfiguration(NetworkResourceConfiguration networkResourceConfiguration) {
        this.networkResourceConfiguration = networkResourceConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration networkResourceConfiguration) {
        this.networkResourceConfiguration = networkResourceConfiguration;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.networkResourceConfiguration;
    }
}

