/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.MOUtils;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectChangeStrategy;
import com.bwanms.mo.ManagedObjectSupport;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.persistence.Transient;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.log4j.Logger;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnifiedMOSupport<M extends ManagedObject>
extends ManagedObjectSupport {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer("com.bwanms.validator");
    private static final ResourceBundle bundle = i18n.asBundle();
    private static final Logger logger = Logger.getLogger(UnifiedMOSupport.class);
    private static final Map<Class, ClassValidator> validators = new HashMap<Class, ClassValidator>();
    private static final MOComparator moComparator = new MOComparator();
    private final transient Map<String, M> originalInstances = new LinkedHashMap<String, M>();
    private transient ManagedObjectChangeStrategy changeStrategy;
    private final Class<M> moClass;
    private String nrConfigName;
    private final Map<String, M> newInstances = new HashMap<String, M>();
    private final Map<String, M> changedInstances = new HashMap<String, M>();
    private final Map<String, M> removedInstances = new HashMap<String, M>();

    public UnifiedMOSupport(Class<M> moClass, List<M> originalInstances) {
        this.moClass = moClass;
        for (ManagedObject moInst : originalInstances) {
            this.originalInstances.put(moInst.getRowKey(), moInst);
        }
    }

    public String getNRConfigName() {
        return this.nrConfigName;
    }

    public void setNRConfigName(String nrConfigName) {
        this.nrConfigName = nrConfigName;
    }

    @Override
    public NetworkResourceConfiguration getNRConfiguration() {
        throw new UnsupportedOperationException("This method is not supported anymore in UnifiedMOsupport");
    }

    @Override
    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        throw new UnsupportedOperationException("This method is not supported anymore in UnifiedMOsupport");
    }

    @Override
    public String getRowKey() {
        return "0";
    }

    public Class<M> getParameterClass() {
        return this.moClass;
    }

    @Transient
    public Collection<M> getInstances() {
        return new MOProxyCollection<M>(this.originalInstances.values(), this.moClass);
    }

    public Collection<M> getNewInstances() {
        ArrayList<M> sortedInstancesList = new ArrayList<M>(this.newInstances.values());
        Collections.sort(sortedInstancesList, moComparator);
        return Collections.unmodifiableCollection(sortedInstancesList);
    }

    public Collection<M> getChangedInstances() {
        return Collections.unmodifiableCollection(this.changedInstances.values());
    }

    public Collection<M> getRemovedInstances() {
        return Collections.unmodifiableCollection(this.removedInstances.values());
    }

    public void addInstance(M newInstance) {
        if (!DynamicTableRowMO.class.isAssignableFrom(this.moClass)) {
            throw new UnsupportedOperationException("Cannot add a new instance to a static table or a scalar group: " + this.moClass.getName());
        }
        String rowKey = newInstance.getRowKey();
        M oldInstance = this.findInstance(rowKey);
        if (oldInstance != null && !this.newInstances.containsKey(rowKey)) {
            throw new DuplicateEntryException(this.moClass, rowKey);
        }
        Collection<M> mappedNewInstances = this.newInstances.values();
        if (mappedNewInstances.contains(newInstance) && !newInstance.equals(this.newInstances.get(rowKey))) {
            throw new RuntimeException("Duplicate mapping for new instance " + rowKey);
        }
        this.newInstances.put(rowKey, newInstance);
    }

    public void updateInstance(M updateInstance) {
        String rowKey = updateInstance.getRowKey();
        this.checkRowKey(rowKey);
        if (updateInstance == this.newInstances.get(rowKey)) {
            return;
        }
        if (this.newInstances.containsKey(rowKey) || this.removedInstances.containsKey(rowKey)) {
            throw new IllegalArgumentException("[" + this.moClass.getName() + "] inconsistent entries at updateInstance()");
        }
        if (!this.changedInstances.containsKey(rowKey) || updateInstance != this.changedInstances.get(rowKey)) {
            M newUpdateInstance = this.findInstance(rowKey);
            if (newUpdateInstance == null) {
                throw new IllegalArgumentException("[" + this.moClass.getName() + "] given updateInstance does not belong to this UnifiedMOSupport.");
            }
            BeanUtils.copyNotNullSNMPProperties(updateInstance, newUpdateInstance);
            this.changedInstances.put(rowKey, newUpdateInstance);
            return;
        }
        this.changedInstances.put(rowKey, updateInstance);
    }

    public void removeInstance(String rowKey) {
        if (!DynamicTableRowMO.class.isAssignableFrom(this.moClass)) {
            throw new UnsupportedOperationException("Cannot remove an instance from a static table or a scalar group");
        }
        this.checkRowKey(rowKey);
        if (this.originalInstances.get(rowKey) != null) {
            this.removedInstances.put(rowKey, this.originalInstances.get(rowKey));
        }
        this.newInstances.remove(rowKey);
        this.changedInstances.remove(rowKey);
    }

    public void revertInstance(String rowKey) {
        if (this.newInstances.remove(rowKey) != null) {
            return;
        }
        if (this.changedInstances.remove(rowKey) != null) {
            return;
        }
        if (this.removedInstances.remove(rowKey) != null) {
            return;
        }
        if (!this.originalInstances.containsKey(rowKey)) {
            throw new IllegalArgumentException("[" + this.moClass.getName() + "] inconsistent entries: given rowKey " + rowKey + " does not belong to this UnifiedMOSupport");
        }
    }

    public M findInstance(String rowKey) {
        this.checkRowKey(rowKey);
        ManagedObject instance = null;
        instance = (ManagedObject)this.newInstances.get(rowKey);
        if (instance != null) {
            return (M)instance;
        }
        instance = (ManagedObject)this.changedInstances.get(rowKey);
        if (instance != null) {
            return (M)instance;
        }
        instance = (ManagedObject)this.originalInstances.get(rowKey);
        if (instance != null) {
            ManagedObject moClone = instance.clone();
            this.changedInstances.put(rowKey, moClone);
            return (M)moClone;
        }
        return null;
    }

    public boolean findRowKey(String rowKey) {
        return this.originalInstances.containsKey(rowKey) || this.changedInstances.containsKey(rowKey) || this.newInstances.containsKey(rowKey);
    }

    @Transient
    public M getInstance(String rowKey) {
        ManagedObject mo = (ManagedObject)this.originalInstances.get(rowKey);
        return (M)(mo == null ? null : (ManagedObject)MOProxyFactory.createProxy(this.moClass, mo));
    }

    public List<String> getChangedRowKeys() {
        ArrayList<String> changedRowKeys = new ArrayList<String>(this.newInstances.size() + this.changedInstances.size() + this.removedInstances.size());
        changedRowKeys.addAll(this.newInstances.keySet());
        changedRowKeys.addAll(this.changedInstances.keySet());
        changedRowKeys.addAll(this.removedInstances.keySet());
        return changedRowKeys;
    }

    public boolean isInstanceChanged(String rowKey) {
        return this.isInstanceChanged(rowKey, null);
    }

    public boolean isInstanceChanged(String rowKey, Set<String> excludedParameters) {
        this.checkRowKey(rowKey);
        ManagedObject changedInst = (ManagedObject)this.changedInstances.get(rowKey);
        if (changedInst != null) {
            return MOUtils.changedMO((ManagedObject)this.originalInstances.get(rowKey), changedInst, excludedParameters);
        }
        if (this.newInstances.containsKey(rowKey) || this.removedInstances.containsKey(rowKey)) {
            return true;
        }
        if (this.originalInstances.containsKey(rowKey)) {
            return false;
        }
        throw new IllegalArgumentException("[" + this.moClass.getName() + "] inconsistent entries: given rowKey " + rowKey + " does not belong to this UnifiedMOSupport");
    }

    protected final void checkRowKey(String rowKey) {
        if (rowKey == null) {
            throw new NullPointerException("[" + this.moClass.getName() + "] entry cannot have null rowKey");
        }
    }

    @Override
    public ManagedObjectChangeStrategy getChangeStrategy() {
        if (this.changeStrategy == null) {
            this.changeStrategy = new UnifiedMOChangeStrategy();
        }
        return this.changeStrategy;
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
        this.validateDeclaredConstraints(invalidValues);
        try {
            this.validateUndeclaredConstraints(invalidValues);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        if (ManagedObjectSupport.class.isAssignableFrom(this.getParameterClass())) {
            for (ManagedObject entry : this.newInstances.values()) {
                ((ManagedObjectSupport)entry).validateUndeclaredConstraints(invalidValues);
            }
            for (ManagedObject entry : this.changedInstances.values()) {
                ((ManagedObjectSupport)entry).validateUndeclaredConstraints(invalidValues);
            }
        }
    }

    protected final void validateDeclaredConstraints(List<InvalidValue> invalidValues) {
        for (ManagedObject entry : this.newInstances.values()) {
            this.addInvalidValues(invalidValues, this.initValidator(this.moClass).getInvalidValues((Object)entry));
        }
        for (ManagedObject entry : this.changedInstances.values()) {
            this.addInvalidValues(invalidValues, this.initValidator(this.moClass).getInvalidValues((Object)entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transient
    public ClassValidator<M> initValidator(Class<M> clazz) {
        Map<Class, ClassValidator> map = validators;
        synchronized (map) {
            ClassValidator result = validators.get(clazz);
            if (result == null) {
                result = new ClassValidator(clazz, bundle);
                validators.put(clazz, result);
            }
            return result;
        }
    }

    private void addInvalidValues(List<InvalidValue> result, InvalidValue[] invalidValues) {
        for (InvalidValue value : invalidValues) {
            result.add(value);
        }
    }

    public static Internationalizer getInternationalizer() {
        return i18n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MOProxyCollection<M>
    implements Collection<M> {
        private final Collection<? extends M> collection;
        private final Class<? extends M> type;

        public MOProxyCollection(Collection<? extends M> collection, Class<? extends M> type) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection cannot be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Collection type cannot be null");
            }
            for (M mo : collection) {
                if (type.isInstance(mo)) continue;
                throw new IllegalArgumentException("MO Instance type " + mo.getClass().getName() + " does not match collection type " + type.getName());
            }
            this.collection = collection;
            this.type = type;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.collection.containsAll(coll);
        }

        public String toString() {
            return this.collection.toString();
        }

        @Override
        public Iterator<M> iterator() {
            return new Iterator<M>(){
                Iterator<? extends M> iter;
                {
                    this.iter = MOProxyCollection.this.collection.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public M next() {
                    return MOProxyFactory.createProxy(MOProxyCollection.this.type, this.iter.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(M o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends M> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MOProxyFactory {
        static CallbackFilter filter = new CallbackFilter(){

            public int accept(Method method) {
                String name = method.getName();
                if (name.startsWith("get") || name.startsWith("is")) {
                    return 2;
                }
                if (name.startsWith("set")) {
                    return 1;
                }
                return 0;
            }
        };
        static Callback nullInvocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        };
        static Callback unsupportedInvocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException("MO Proxy - Setter invocation unsupported");
            }
        };

        private MOProxyFactory() {
        }

        static Object createProxy(Class<?> type, Object obj) {
            if (type == null) {
                throw new IllegalArgumentException("Proxy type cannot be null");
            }
            if (obj == null) {
                throw new IllegalArgumentException("Instance cannot be null");
            }
            if (!type.isInstance(obj)) {
                throw new IllegalArgumentException("Instance type does not match proxy type");
            }
            Object mo = obj;
            return Enhancer.create(type, null, (CallbackFilter)filter, (Callback[])new Callback[]{nullInvocationHandler, unsupportedInvocationHandler, new DefaultInvocationHandler(mo)});
        }

        static class DefaultInvocationHandler
        implements InvocationHandler {
            Object obj;

            public DefaultInvocationHandler(Object obj) {
                this.obj = obj;
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(this.obj, args);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MOComparator
    implements Comparator<ManagedObject> {
        private MOComparator() {
        }

        @Override
        public int compare(ManagedObject o1, ManagedObject o2) {
            return o1.getRowKey().compareTo(o2.getRowKey());
        }
    }

    private class UnifiedMOChangeStrategy
    implements ManagedObjectChangeStrategy {
        private UnifiedMOChangeStrategy() {
        }

        public void acknowledge() {
            UnifiedMOSupport.this.newInstances.clear();
            UnifiedMOSupport.this.changedInstances.clear();
            UnifiedMOSupport.this.removedInstances.clear();
        }

        public boolean isChanged() {
            if (!UnifiedMOSupport.this.changedInstances.isEmpty()) {
                for (ManagedObject changedInst : UnifiedMOSupport.this.changedInstances.values()) {
                    ManagedObject origInst = (ManagedObject)UnifiedMOSupport.this.originalInstances.get(changedInst.getRowKey());
                    if (!MOUtils.changedMO(origInst, changedInst)) continue;
                    return true;
                }
            }
            return !UnifiedMOSupport.this.newInstances.isEmpty() || !UnifiedMOSupport.this.removedInstances.isEmpty();
        }

        public void reset() {
            UnifiedMOSupport.this.newInstances.clear();
            UnifiedMOSupport.this.changedInstances.clear();
            UnifiedMOSupport.this.removedInstances.clear();
        }
    }
}

