/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.meta.filters.AttributeFilter;
import com.bwanms.meta.filters.AttributeFilterFactory;
import com.bwanms.meta.mo.LegacyManagedObjects;
import com.bwanms.meta.mo.ManagedObjects;
import com.bwanms.mo.AbstractTableMO;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.MOUtils;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Equipment;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.PlatformConfiguration;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BwNetworkResourceConfiguration")
public abstract class NetworkResourceConfiguration
implements Serializable {
    private static final Logger log = Logger.getLogger(NetworkResourceConfiguration.class);
    private static HashMap<String, Method> managedObjectGetters = new HashMap();
    private static HashMap<String, Method> legacyMOGetters = new HashMap();
    private EquipmentConfiguration configuration;
    private String name;
    private long id;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToOne
    @JoinColumn(name="configurationId")
    public EquipmentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EquipmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public final <T extends ManagedObject> T findManagedObject(Class<T> moClass) {
        try {
            Method[] methods;
            for (Method method : methods = this.getClass().getMethods()) {
                if (!method.getName().startsWith("get") || !method.getReturnType().equals(moClass)) continue;
                ManagedObject ret = (ManagedObject)method.invoke((Object)this, new Object[0]);
                return (T)ret;
            }
            throw new RuntimeException("No getter defined: " + this.getClass().getName() + ".get" + moClass.getName().substring(moClass.getName().lastIndexOf(".") + 1) + "():" + moClass.getName() + "\nAdd this code:\n" + this.getDeclaringCode(moClass.getName().substring(moClass.getName().lastIndexOf(".") + 1)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getDeclaringCode(String moName) {
        StringBuilder sb = new StringBuilder();
        String moVar = Character.toLowerCase(moName.charAt(0)) + moName.substring(1);
        sb.append(" private " + moName + " " + moVar + ";\n");
        sb.append(" @OneToOne(mappedBy = \"NRConfiguration\", cascade = CascadeType.ALL)\n");
        sb.append(" public " + moName + " get" + moName + "()\n");
        sb.append("{\n");
        sb.append("     // TODO remove this hack\n");
        sb.append("     if (" + moVar + " == null) {\n");
        sb.append("         " + moVar + " = new " + moName + "();\n");
        sb.append("         " + moVar + ".setNRConfiguration(this);\n");
        sb.append("     }\n");
        sb.append("     return " + moVar + ";\n");
        sb.append(" }\n");
        sb.append(" public void set" + moName + "(" + moName + " " + moVar + ")\n");
        sb.append(" {\n");
        sb.append("     this." + moVar + " = " + moVar + ";\n");
        sb.append(" }\n");
        return sb.toString();
    }

    @Deprecated
    public final <T extends ManagedObject> void updateManagedObject(T managedObject) {
        Class<?> moClass = managedObject.getClass();
        try {
            Method[] methods;
            for (Method method : methods = this.getClass().getMethods()) {
                Class<?>[] parameters;
                if (!method.getName().startsWith("set") || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].equals(moClass)) continue;
                method.invoke((Object)this, managedObject);
                return;
            }
            throw new RuntimeException("No setter defined: " + this.getClass().getName() + ".set" + moClass.getName().substring(moClass.getName().lastIndexOf(".") + 1) + "(" + moClass.getName() + ")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Transient
    public abstract Equipment getManagedEquipment();

    @Transient
    public Equipment getConfigurationEquipment() {
        return this.getConfiguration().getEquipment();
    }

    @Transient
    public List<Class<? extends ManagedObject>> getManagedObjectClasses() {
        try {
            ArrayList<Class<? extends ManagedObject>> ret = new ArrayList<Class<? extends ManagedObject>>();
            AttributeFilter filter = AttributeFilterFactory.createFilter(this.getConfiguration().getEquipment(), this.getClass());
            for (Method getter : BeanUtils.getPropertyGetters(this.getClass())) {
                ManagedObjects annotation = getter.getAnnotation(ManagedObjects.class);
                if (annotation == null || !filter.acceptAttribute(BeanUtils.getPropertyNameFromGetter(getter))) continue;
                ret.add(annotation.moClass());
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final List<Class<? extends ManagedObject>> listManagedObjectClasses() {
        return null;
    }

    public <M extends ManagedObject> Map<String, M> retrieveManagedObjects(Class<M> moClass, Collection<String> instances) {
        Session session = Datastore.session();
        this.lock();
        HashMap<String, ManagedObject> ret = new HashMap<String, ManagedObject>();
        Collection<M> persistentCollection = this.retrievePersistentCollection(moClass);
        if (instances != null && instances.size() > 0) {
            ArrayList<String> instanceList = new ArrayList<String>(instances);
            Collections.sort(instanceList);
            for (ManagedObject mo : persistentCollection) {
                int index = Collections.binarySearch(instanceList, mo.getRowKey());
                if (index < 0) continue;
                ret.put(mo.getRowKey(), mo);
            }
        }
        return ret;
    }

    public <M extends ManagedObject> List<M> retrieveManagedObjects(Class<M> moClass, String instanceQuery) {
        this.lock();
        List<M> ret = new ArrayList<M>();
        Collection<M> persistentCollection = this.retrievePersistentCollection(moClass);
        if (persistentCollection != null) {
            ret = this.filterPersistentCollection(persistentCollection, instanceQuery);
        } else {
            ret.add(this.retrieveLegacyManagedObjects(moClass));
        }
        return ret;
    }

    public void lock() {
        if (PlatformConfiguration.isLocalPlatform()) {
            final Lock lock = LockManagerLocator.locate().getLock(this.getClass().getName() + "#" + this.id);
            lock.lock();
            Datastore.addFinallyOperation(new Runnable(){

                public void run() {
                    lock.unlock();
                }
            });
        } else {
            Datastore.session().lock((Object)this, LockMode.UPGRADE);
        }
    }

    public <M extends ManagedObject> List<M> persistManagedObjects(Class<M> moClass, String instanceQuery, List<M> valueMOs, int updateMode, Collection<String> outChangedInstances) {
        boolean found;
        Session session = Datastore.session();
        this.lock();
        Collection<M> persistentCollection = this.retrievePersistentCollection(moClass);
        if (persistentCollection == null) {
            return this.persistLegacyManagedObjects(valueMOs, updateMode);
        }
        List<M> queriedCollection = this.filterPersistentCollection(persistentCollection, instanceQuery);
        for (ManagedObject value : valueMOs) {
            found = false;
            for (ManagedObject persistent : queriedCollection) {
                if (!value.getRowKey().equals(persistent.getRowKey())) continue;
                boolean changed = MOUtils.updateMO(persistent, value, updateMode);
                if (outChangedInstances != null && changed) {
                    outChangedInstances.add(persistent.getRowKey());
                }
                session.update((Object)persistent);
                found = true;
                break;
            }
            if (found) continue;
            ManagedObject persistent = value.clone();
            persistent.setNRConfiguration(this);
            persistentCollection.add(persistent);
            if (outChangedInstances != null) {
                outChangedInstances.add(persistent.getRowKey());
            }
            session.save((Object)persistent);
        }
        for (ManagedObject persistent : queriedCollection) {
            found = false;
            for (ManagedObject value : valueMOs) {
                if (!persistent.getRowKey().equals(value.getRowKey())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (outChangedInstances != null) {
                outChangedInstances.add(persistent.getRowKey());
            }
            persistent.setNRConfiguration(null);
            persistentCollection.remove(persistent);
            session.delete((Object)persistent);
        }
        this.persistPersistentCollection(moClass, persistentCollection);
        return this.filterPersistentCollection(persistentCollection, instanceQuery);
    }

    public <M extends ManagedObject> Collection<M> persistManagedObjects(UnifiedMOSupport<M> valueMOs, int updateMode, Collection<String> outChangedInstances) {
        ManagedObject persistentInst;
        Session session = Datastore.session();
        this.lock();
        Collection<M> persistentCollection = this.retrievePersistentCollection(valueMOs.getParameterClass());
        Map<String, M> persistentMap = this.retrieveManagedObjects(valueMOs.getParameterClass(), valueMOs.getChangedRowKeys());
        for (ManagedObject valueInst : valueMOs.getRemovedInstances()) {
            persistentInst = (ManagedObject)persistentMap.remove(valueInst.getRowKey());
            if (persistentInst == null) continue;
            if (outChangedInstances != null) {
                outChangedInstances.add(persistentInst.getRowKey());
            }
            persistentInst.setNRConfiguration(null);
            persistentCollection.remove(persistentInst);
            session.delete((Object)persistentInst);
        }
        for (ManagedObject valueInst : valueMOs.getChangedInstances()) {
            persistentInst = (ManagedObject)persistentMap.get(valueInst.getRowKey());
            if (persistentInst == null) continue;
            boolean changed = MOUtils.updateMO(persistentInst, valueInst, updateMode);
            if (outChangedInstances != null && changed) {
                outChangedInstances.add(persistentInst.getRowKey());
            }
            session.update((Object)persistentInst);
        }
        for (ManagedObject valueInst : valueMOs.getNewInstances()) {
            persistentInst = valueInst.clone();
            persistentInst.setNRConfiguration(this);
            persistentMap.put(persistentInst.getRowKey(), persistentInst);
            persistentCollection.add(persistentInst);
            if (outChangedInstances != null) {
                outChangedInstances.add(persistentInst.getRowKey());
            }
            session.save((Object)persistentInst);
        }
        this.persistPersistentCollection(valueMOs.getParameterClass(), persistentCollection);
        return persistentCollection;
    }

    private <M extends ManagedObject> M retrieveLegacyManagedObjects(Class<M> moClass) {
        String key = this.getClass().getName() + "_" + moClass.getName();
        Method cachedGetter = legacyMOGetters.get(key);
        if (cachedGetter != null) {
            try {
                return (M)((ManagedObject)cachedGetter.invoke((Object)this, BeanUtils.NO_PARAMS));
            }
            catch (Exception e) {
                throw new AssertionError((Object)(e.getMessage() + " when trying to retrieve " + moClass.getName() + " in " + this.getClass().getName()));
            }
        }
        for (Method getter : BeanUtils.getPropertyGetters(this.getClass())) {
            LegacyManagedObjects annotation = getter.getAnnotation(LegacyManagedObjects.class);
            if (annotation == null || !moClass.equals(annotation.moClass())) continue;
            try {
                legacyMOGetters.put(key, getter);
                return (M)((ManagedObject)getter.invoke((Object)this, BeanUtils.NO_PARAMS));
            }
            catch (Exception e) {
                throw new AssertionError((Object)(e.getMessage() + " when trying to retrieve " + moClass.getName() + " in " + this.getClass().getName()));
            }
        }
        throw new AssertionError((Object)(moClass.getName() + " not found in " + this.getClass().getName()));
    }

    private <M extends ManagedObject> List<M> persistLegacyManagedObjects(List<M> valueMOs, int updateMode) {
        ManagedObject moTable = (ManagedObject)valueMOs.get(0);
        if (moTable instanceof AbstractTableMO) {
            return this.persistManagedObjects(((AbstractTableMO)moTable).getParameterClass(), null, ((AbstractTableMO)moTable).getEntries(), updateMode, null);
        }
        return null;
    }

    private <M extends ManagedObject> Collection<M> retrievePersistentCollection(Class<M> moClass) {
        String key = this.getClass().getName() + "_" + moClass.getName();
        Method cachedGetter = managedObjectGetters.get(key);
        if (cachedGetter != null) {
            try {
                return (Collection)cachedGetter.invoke((Object)this, BeanUtils.NO_PARAMS);
            }
            catch (Exception e) {
                throw new AssertionError((Object)(e.getMessage() + " when trying to retrieve " + moClass.getName() + " in " + this.getClass().getName()));
            }
        }
        for (Method getter : BeanUtils.getPropertyGetters(this.getClass())) {
            ManagedObjects annotation = getter.getAnnotation(ManagedObjects.class);
            if (annotation != null) {
                if (!moClass.equals(annotation.moClass())) continue;
                try {
                    managedObjectGetters.put(key, getter);
                    return (Collection)getter.invoke((Object)this, BeanUtils.NO_PARAMS);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)(e.getMessage() + " when trying to retrieve " + moClass.getName() + " in " + this.getClass().getName()));
                }
            }
            LegacyManagedObjects annotation2 = getter.getAnnotation(LegacyManagedObjects.class);
            if (annotation2 == null || !moClass.equals(annotation2.moClass())) continue;
            return null;
        }
        throw new AssertionError((Object)(moClass.getName() + " not found in " + this.getClass().getName()));
    }

    private <M extends ManagedObject> void persistPersistentCollection(Class<M> moClass, Collection<M> persistentCollection) {
        for (Method getter : BeanUtils.getPropertyGetters(this.getClass())) {
            ManagedObjects annotation = getter.getAnnotation(ManagedObjects.class);
            if (annotation == null || !moClass.equals(annotation.moClass())) continue;
            try {
                Method setter = BeanUtils.getSetter(this.getClass(), BeanUtils.getPropertyNameFromGetter(getter));
                setter.invoke((Object)this, persistentCollection);
                return;
            }
            catch (Exception e) {
                throw new AssertionError((Object)(e.getMessage() + " when trying to retrieve " + moClass.getName() + " in " + this.getClass().getName()));
            }
        }
        throw new AssertionError((Object)(moClass.getName() + " not found in " + this.getClass().getName()));
    }

    private <M extends ManagedObject> List<M> filterPersistentCollection(Collection<M> persistentCollection, String instanceQuery) {
        ArrayList<Object> ret;
        block11: {
            block14: {
                block13: {
                    block12: {
                        ret = new ArrayList<Object>();
                        if (persistentCollection.isEmpty()) {
                            return ret;
                        }
                        if (instanceQuery != null && instanceQuery.length() != 0 && !instanceQuery.equals("*")) break block12;
                        ret.addAll(persistentCollection);
                        break block11;
                    }
                    if (!instanceQuery.endsWith("*")) break block13;
                    if (instanceQuery.indexOf(",") > -1 || instanceQuery.indexOf("+") > -1) {
                        throw new AssertionError((Object)("Wrong instance query format: " + instanceQuery));
                    }
                    String prefix = instanceQuery.substring(0, instanceQuery.length() - 1);
                    for (ManagedObject mo : persistentCollection) {
                        if (!mo.getRowKey().startsWith(prefix)) continue;
                        ret.add(mo);
                    }
                    break block11;
                }
                if (!instanceQuery.endsWith("+")) break block14;
                if (instanceQuery.indexOf(",") > -1 || instanceQuery.indexOf("*") > -1) {
                    throw new AssertionError((Object)("Wrong instance query format: " + instanceQuery));
                }
                String startInstance = instanceQuery.substring(0, instanceQuery.length() - 1);
                for (ManagedObject mo : persistentCollection) {
                    if (mo.getRowKey().compareTo(startInstance) < 0) continue;
                    ret.add(mo);
                }
                break block11;
            }
            if (instanceQuery.indexOf("+") > -1 || instanceQuery.indexOf("*") > -1) {
                throw new AssertionError((Object)("Wrong instance query format: " + instanceQuery));
            }
            String[] instances = instanceQuery.split(",");
            if (instances == null || instances.length <= 0) break block11;
            if (instances.length > 1) {
                ArrayList<String> instanceList = new ArrayList<String>();
                for (String inst : instances) {
                    instanceList.add(inst);
                }
                Collections.sort(instanceList);
                for (ManagedObject mo : persistentCollection) {
                    int index = Collections.binarySearch(instanceList, mo.getRowKey());
                    if (index < 0) continue;
                    ret.add(mo);
                }
            } else {
                for (ManagedObject mo : persistentCollection) {
                    if (!mo.getRowKey().equals(instances[0])) continue;
                    ret.add(mo);
                    break;
                }
            }
        }
        return ret;
    }
}

