/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.mo.ManagedObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectRequest
implements Serializable {
    private String networkResourceId;
    private Class<? extends ManagedObject> moClass;

    public ManagedObjectRequest(String networkResourceId, Class<? extends ManagedObject> moClass) {
        this.networkResourceId = networkResourceId;
        this.moClass = moClass;
    }

    public Class<? extends ManagedObject> getMoClass() {
        return this.moClass;
    }

    public String getNetworkResourceId() {
        return this.networkResourceId;
    }

    public boolean equals(Object target) {
        ManagedObjectRequest req = (ManagedObjectRequest)target;
        return this.networkResourceId.equals(req.networkResourceId) && this.moClass.equals(req.moClass);
    }

    public List<ManagedObject> getMatchingMOs(Collection<ManagedObject> mos) {
        ArrayList<ManagedObject> ret = new ArrayList<ManagedObject>();
        for (ManagedObject mo : mos) {
            if (!this.networkResourceId.equals(mo.getNRConfiguration().getName()) || !this.moClass.isAssignableFrom(mo.getClass())) continue;
            ret.add(mo);
        }
        return ret;
    }
}

