/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.mo.ManagedObject;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedObjectIntrospector {
    private static final Logger log = Logger.getLogger(ManagedObjectIntrospector.class);
    private HashMap<Class<? extends ManagedObject>, ArrayList<Method>> managedParameterGetters = new HashMap();

    protected abstract boolean isConfigurationGetter(Method var1);

    protected abstract boolean isManagedGetter(Method var1);

    protected List<Method> getManagedParameterGetters(Class<? extends ManagedObject> moClass) {
        ArrayList<Method> ret = this.managedParameterGetters.get(moClass);
        if (ret == null) {
            ret = new ArrayList();
            for (Method getter : BeanUtils.getPropertyGetters(moClass)) {
                if (!this.isManagedGetter(getter)) continue;
                ret.add(getter);
            }
            this.managedParameterGetters.put(moClass, ret);
        }
        return ret;
    }

    public String[] getConfigurationAttributes(Class<? extends ManagedObject> moClass) {
        ArrayList<String> retList = new ArrayList<String>();
        for (Method getter : BeanUtils.getPropertyGetters(moClass)) {
            if (!this.isConfigurationGetter(getter)) continue;
            retList.add(BeanUtils.getPropertyNameFromGetter(getter));
        }
        return retList.toArray(new String[retList.size()]);
    }

    public ArrayList<String> getChangedConfigurationParameters(ManagedObject source, ManagedObject target) {
        try {
            if (!target.getClass().equals(source.getClass())) {
                throw new RuntimeException("");
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (Method getter : this.getManagedParameterGetters(source.getClass())) {
                if (!this.isConfigurationGetter(getter)) continue;
                String paramName = BeanUtils.getPropertyNameFromGetter(getter);
                Object sourceValue = getter.invoke((Object)source, new Object[0]);
                Object targetValue = getter.invoke((Object)target, new Object[0]);
                if (sourceValue != null) {
                    if (sourceValue.equals(targetValue)) continue;
                    ret.add(paramName + " " + targetValue + " -> " + sourceValue);
                    continue;
                }
                if (targetValue == null) continue;
                ret.add(paramName + " " + targetValue + " ->  null");
            }
            if (ret.size() > 0) {
                log.debug((Object)("Not equals[ " + source.getClass() + " ] " + ret));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateManagedProperties(ManagedObject source, ManagedObject target) {
        if (!source.getClass().equals(target.getClass())) {
            throw new AssertionError((Object)(source.getClass().getName() + " != " + target.getClass().getName()));
        }
        try {
            for (Method getter : this.getManagedParameterGetters(source.getClass())) {
                Method setter = BeanUtils.getSetter(source.getClass(), BeanUtils.getPropertyNameFromGetter(getter));
                if (setter == null) continue;
                setter.invoke((Object)target, getter.invoke((Object)source, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

