/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.protocols.Protocol;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagedObjectAccessHandlerRegistry {
    private static ManagedObjectAccessHandlerRegistry instance = null;
    private Map<String, ManagedObjectAccessHandlerFactory<? extends ManagedObject>> handlerFactories = new HashMap<String, ManagedObjectAccessHandlerFactory<? extends ManagedObject>>();

    private ManagedObjectAccessHandlerRegistry() {
    }

    public static ManagedObjectAccessHandlerRegistry instance() {
        if (instance == null) {
            instance = new ManagedObjectAccessHandlerRegistry();
        }
        return instance;
    }

    public static <M extends ManagedObject> void registerHandler(Class<M> moClass, Class<? extends Protocol> protocol, ManagedObjectAccessHandlerFactory<M> moHandlerFactory) {
        ManagedObjectAccessHandlerRegistry.instance().handlerFactories.put(moClass.getName() + "+" + protocol.getName(), moHandlerFactory);
    }

    public static <M extends ManagedObject> ManagedObjectAccessHandler<M> findHandler(Class<M> moClass, Class<? extends Protocol> protocol) {
        ManagedObjectAccessHandlerFactory<? extends ManagedObject> factory = ManagedObjectAccessHandlerRegistry.instance().handlerFactories.get(moClass.getName() + "+" + protocol.getName());
        if (factory == null) {
            throw new AssertionError((Object)("No MOHandlerFactory defined for [" + moClass.getName() + ", " + protocol.getName() + "]"));
        }
        return factory.createHandler();
    }
}

