/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.meta.filters.AttributeFilter;
import com.bwanms.meta.filters.AttributeFilterFactory;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.util.BeanUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.persistence.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MOUtils {
    public static final int UPDATE_CONFIG = 1;
    public static final int UPDATE_STATE = 2;
    public static final int UPDATE_INVENTORY = 4;
    public static final int UPDATE_STATE_INVENTORY = 6;
    public static final int UPDATE_ALL = 7;

    public static boolean updateMO(ManagedObject persistent, ManagedObject value, int updateMode) {
        boolean changed = false;
        for (Method getter : BeanUtils.getPropertyGetters(value.getClass())) {
            String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
            Method setter = null;
            try {
                if (getter.getAnnotation(ConfigAttribute.class) != null && (updateMode & 1) == 1) {
                    setter = BeanUtils.getSetter(persistent.getClass(), propertyName);
                } else if (getter.getAnnotation(StateAttribute.class) != null && (updateMode & 2) == 2) {
                    setter = BeanUtils.getSetter(persistent.getClass(), propertyName);
                } else if (getter.getAnnotation(InventoryAttribute.class) != null && (updateMode & 4) == 4) {
                    setter = BeanUtils.getSetter(persistent.getClass(), propertyName);
                }
                if (setter == null) continue;
                if (!changed) {
                    changed = !BeanUtils.equalsNullAware(getter.invoke((Object)persistent, new Object[0]), getter.invoke((Object)value, new Object[0]));
                }
                setter.invoke((Object)persistent, getter.invoke((Object)value, BeanUtils.NO_PARAMS));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return changed;
    }

    public static void resetMO(ManagedObject mo, int resetMode) {
        for (Method getter : BeanUtils.getPropertyGetters(mo.getClass())) {
            String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
            Method setter = null;
            try {
                if (getter.getAnnotation(ConfigAttribute.class) != null && (resetMode & 1) == 1) {
                    setter = BeanUtils.getSetter(mo.getClass(), propertyName);
                } else if (getter.getAnnotation(StateAttribute.class) != null && (resetMode & 2) == 2) {
                    setter = BeanUtils.getSetter(mo.getClass(), propertyName);
                } else if (getter.getAnnotation(InventoryAttribute.class) != null && (resetMode & 4) == 4) {
                    setter = BeanUtils.getSetter(mo.getClass(), propertyName);
                }
                if (setter == null) continue;
                setter.invoke((Object)mo, new Object[]{null});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <M extends ManagedObject> boolean changedMO(M origMO, M changedMO) {
        return MOUtils.changedMO(origMO, changedMO, null);
    }

    public static <M extends ManagedObject> boolean changedMO(M origMO, M changedMO, Set<String> excludedParameters) {
        boolean changed = false;
        Class<?> moClass = origMO.getClass();
        if (moClass.getAnnotation(Entity.class) == null && (moClass = changedMO.getClass()).getAnnotation(Entity.class) == null) {
            throw new IllegalArgumentException("Cannot compare 2 proxy MOs");
        }
        for (Method getter : BeanUtils.getPropertyGetters(moClass)) {
            String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
            if (excludedParameters != null && excludedParameters.contains(propertyName)) continue;
            try {
                if (getter.getAnnotation(ConfigAttribute.class) == null) continue;
                Object oldValue = getter.invoke(origMO, BeanUtils.NO_PARAMS);
                Object newValue = getter.invoke(changedMO, BeanUtils.NO_PARAMS);
                if (oldValue != null && newValue != null) {
                    if (oldValue.equals(newValue)) continue;
                    changed = true;
                    break;
                }
                if (oldValue == null && newValue == null) continue;
                changed = true;
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return changed;
    }

    public static boolean hasAnnotatedAttributes(Class<? extends ManagedObject> moClass, Class<? extends Annotation>[] annoClasses) {
        for (Method getter : BeanUtils.getPropertyGetters(moClass)) {
            for (Class<? extends Annotation> annoClass : annoClasses) {
                if (getter.getAnnotation(annoClass) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNullAnnotatedAttributes(Equipment eq, ManagedObject mo, Class<? extends Annotation>[] annoClasses) {
        AttributeFilter filter = AttributeFilterFactory.createFilter(eq, mo.getClass());
        try {
            for (Method getter : BeanUtils.getPropertyGetters(mo.getClass())) {
                if (!filter.acceptAttribute(BeanUtils.getPropertyNameFromGetter(getter))) continue;
                for (Class<? extends Annotation> annoClass : annoClasses) {
                    if (getter.getAnnotation(annoClass) == null || null != getter.invoke((Object)mo, new Object[0])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ManagedObject createMO(Class moClass) {
        try {
            return (ManagedObject)moClass.newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

