/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import java.io.Serializable;
import java.util.Arrays;

public class InstanceQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_ALL = 1;
    public static final int TYPE_PREFIX = 2;
    public static final int TYPE_INSTANCES = 3;
    public static final int TYPE_START_WITH = 4;
    private int queryType;
    private String instanceQuery;
    private String prefix;
    private String[] instances;

    public InstanceQuery(String instanceQuery) {
        this.instanceQuery = instanceQuery;
        if (instanceQuery == null || "".equals(instanceQuery) || "*".equals(instanceQuery)) {
            this.queryType = 1;
        } else if (instanceQuery.endsWith("*")) {
            if (instanceQuery.indexOf(",") > -1 || instanceQuery.indexOf("+") > -1) {
                throw new IllegalArgumentException("[" + instanceQuery + "] is not a legal instance query");
            }
            this.prefix = instanceQuery.substring(0, instanceQuery.length() - 1).trim();
            if (this.prefix.length() == 0) {
                throw new IllegalArgumentException("[" + instanceQuery + "] is not a legal instance query");
            }
            this.queryType = 2;
        } else if (instanceQuery.endsWith("+")) {
            if (instanceQuery.indexOf(",") > -1 || instanceQuery.indexOf("*") > -1) {
                throw new IllegalArgumentException("[" + instanceQuery + "] is not a legal instance query");
            }
            this.prefix = instanceQuery.substring(0, instanceQuery.length() - 1).trim();
            if (this.prefix.length() == 0) {
                throw new IllegalArgumentException("[" + instanceQuery + "] is not a legal instance query");
            }
            this.queryType = 4;
        } else {
            if (instanceQuery.indexOf("+") > -1 || instanceQuery.indexOf("*") > -1) {
                throw new IllegalArgumentException("[" + instanceQuery + "] is not a legal instance query");
            }
            this.instances = instanceQuery.split(",");
            if (this.instances == null || this.instances.length == 0) {
                throw new IllegalArgumentException("[" + instanceQuery + "] is not a legal instance query");
            }
            if (this.instances.length > 1) {
                Arrays.sort(this.instances);
            }
            this.queryType = 3;
        }
    }

    public int getQueryType() {
        return this.queryType;
    }

    public String getInstanceQuery() {
        return this.instanceQuery;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String[] getInstances() {
        return this.instances;
    }

    public boolean matches(String instance) {
        switch (this.queryType) {
            case 1: {
                return true;
            }
            case 2: {
                return instance.startsWith(this.prefix + ".");
            }
            case 3: {
                return Arrays.binarySearch(this.instances, instance) >= 0;
            }
            case 4: {
                return this.prefix.compareTo(instance) <= 0;
            }
        }
        throw new AssertionError((Object)"");
    }

    public String toString() {
        return this.instanceQuery;
    }
}

