/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mo.EquipmentConfigurationConsistencyStrategy;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectRequest;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagementInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BwEquipmentConfiguration", uniqueConstraints={@UniqueConstraint(columnNames={"name", "equipmentId"})})
public abstract class EquipmentConfiguration
implements Serializable {
    private static final Logger logger = Logger.getLogger(EquipmentConfiguration.class);
    private Equipment equipment;
    private long id;
    private String name;
    private Map<String, NetworkResourceConfiguration> networkResources = new HashMap<String, NetworkResourceConfiguration>();

    @ManyToOne
    @JoinColumn(name="equipmentId")
    public Equipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="configuration")
    @MapKey(name="name")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Map<String, NetworkResourceConfiguration> getNetworkResources() {
        return this.networkResources;
    }

    public void setNetworkResources(Map<String, NetworkResourceConfiguration> networkResources) {
        this.networkResources = networkResources;
    }

    public NetworkResourceConfiguration findNetworkResourceConfiguration(String nrName) {
        Map<String, NetworkResourceConfiguration> nrMap = this.getNetworkResources();
        if (nrMap == null) {
            return null;
        }
        return nrMap.get(nrName);
    }

    @Deprecated
    public final <T extends ManagedObject> T findManagedObject(String networkResource, Class<T> moClass) {
        return this.findNetworkResourceConfiguration(networkResource).findManagedObject(moClass);
    }

    public final void updateManagedObject(ManagedObject mo) {
        this.findNetworkResourceConfiguration(mo.getNRConfiguration().getName()).updateManagedObject(mo);
    }

    public void addNetworkResourceConfiguration(NetworkResourceConfiguration nrConfig) {
        Map<String, NetworkResourceConfiguration> nrMap = this.getNetworkResources();
        if (nrMap == null) {
            nrMap = new HashMap<String, NetworkResourceConfiguration>();
            this.setNetworkResources(nrMap);
        }
        nrMap.put(nrConfig.getName(), nrConfig);
    }

    public NetworkResourceConfiguration getNetworkResource(Equipment equipment) {
        return this.networkResources.get(this.getNetworkResourceName(equipment));
    }

    private String getNetworkResourceName(Equipment equipment) {
        throw new RuntimeException("Undefined method.");
    }

    @Transient
    @Deprecated
    public EquipmentConfigurationConsistencyStrategy getChangeStrategy() {
        return new EquipmentConfigurationConsistencyStrategy(){

            @Override
            public List<ManagedObjectRequest> configurationChanged(List<ManagedObject> changedMOs) {
                return new ArrayList<ManagedObjectRequest>();
            }
        };
    }

    @Transient
    public abstract NetworkResourceHandler getNetworkResourceHandler(Class<? extends ManagementInterface> var1);

    @Transient
    public abstract String getPrimaryNetworkResourceConfigurationName();

    @Transient
    public final NetworkResourceConfiguration findPrimaryNetworkResourceConfiguration() {
        return this.findNetworkResourceConfiguration(this.getPrimaryNetworkResourceConfigurationName());
    }
}

