/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mo;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.ManagedObjectChangeStrategy;
import com.bwanms.mo.ManagedObjectSupport;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.TableRowMO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractTableMO<T extends TableRowMO>
extends ManagedObjectSupport {
    private static final long serialVersionUID = -7309120262007248051L;
    private static final Logger logger = Logger.getLogger(AbstractTableMO.class);
    private static final Map<Class, ClassValidator> validators = new HashMap<Class, ClassValidator>();
    private LinkedHashMap<String, T> entries = new LinkedHashMap();
    private ArrayList<String> newEntries = new ArrayList();
    private transient ArrayList<T> removedEntries;
    private transient AbstractTableMOChangeStrategy changeStrategy = null;
    private NetworkResourceConfiguration nrConfiguration;

    public AbstractTableMO(List<T> entries) {
        this.initialize(entries);
    }

    private ArrayList<T> removedEntries() {
        if (this.removedEntries == null) {
            this.removedEntries = new ArrayList();
        }
        return this.removedEntries;
    }

    @Override
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    @Override
    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
        for (TableRowMO entry : this.entries.values()) {
            entry.setNRConfiguration(nrConfiguration);
        }
    }

    public List<T> getEntries() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.entries.values());
        return ret;
    }

    protected void initialize(List<T> sourceEntries) {
        for (TableRowMO entry : sourceEntries) {
            this.entries.put(entry.getRowKey(), entry);
        }
    }

    public void synchronizeCollection(Collection<T> target) {
        logger.debug((Object)("target size: " + target.size()));
        ArrayList<TableRowMO> toRemove = new ArrayList<TableRowMO>();
        for (TableRowMO entry : target) {
            if (this.entries.containsKey(entry.getRowKey())) continue;
            toRemove.add(entry);
        }
        for (TableRowMO entry : toRemove) {
            logger.debug((Object)("removing: " + entry.getRowKey()));
            target.remove(entry);
        }
        HashSet<String> targetKeys = new HashSet<String>();
        for (TableRowMO entry : target) {
            targetKeys.add(entry.getRowKey());
        }
        for (TableRowMO entry : this.entries.values()) {
            if (targetKeys.contains(entry.getRowKey())) continue;
            logger.debug((Object)("adding: " + entry.getRowKey()));
            target.add(entry);
        }
        logger.debug((Object)("target size: " + target.size()));
    }

    public void addEntry(T entry) {
        if (entry.getRowKey() == null) {
            throw new RuntimeException("[" + this.getClass().getName() + "] entry cannot have null instance");
        }
        TableRowMO originalEntry = (TableRowMO)this.entries.get(entry.getRowKey());
        if (originalEntry != null) {
            throw new DuplicateEntryException("[" + this.getClass().getName() + "] entry [" + entry.getRowKey() + "] already in table - update existing");
        }
        entry.setNRConfiguration(this.getNRConfiguration());
        this.entries.put(entry.getRowKey(), entry);
        this.newEntries.add(entry.getRowKey());
    }

    public void removeEntry(String rowKey) {
        TableRowMO entry = (TableRowMO)this.entries.remove(rowKey);
        if (entry != null) {
            this.newEntries.remove(entry);
            this.removedEntries().add(entry);
        }
    }

    public abstract Class<T> getParameterClass();

    @Override
    public ManagedObjectChangeStrategy getChangeStrategy() {
        if (this.changeStrategy == null) {
            this.changeStrategy = new AbstractTableMOChangeStrategy();
        }
        return this.changeStrategy;
    }

    public T findEntry(String rowKey) {
        return (T)((TableRowMO)this.entries.get(rowKey));
    }

    public List<T> findEntriesByRowKeyPrefix(String rowKeyPrefix) {
        ArrayList<TableRowMO> ret = new ArrayList<TableRowMO>();
        for (TableRowMO entry : this.entries.values()) {
            if (!entry.getRowKey().startsWith(rowKeyPrefix)) continue;
            ret.add(entry);
        }
        return ret;
    }

    public List<T> findEntriesByRowKeySuffix(String rowKeySuffix) {
        ArrayList<TableRowMO> ret = new ArrayList<TableRowMO>();
        for (TableRowMO entry : this.entries.values()) {
            if (!entry.getRowKey().endsWith(rowKeySuffix)) continue;
            ret.add(entry);
        }
        return ret;
    }

    public int getSize() {
        return this.entries.size();
    }

    @Override
    public void validate(List<InvalidValue> invalidValues) {
        this.validateDeclaredConstraints(invalidValues);
        try {
            this.validateUndeclaredConstraints(invalidValues);
        }
        catch (Exception e) {
            logger.error((Object)"bad exception in validation", (Throwable)e);
        }
    }

    @Override
    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        if (ManagedObjectSupport.class.isAssignableFrom(this.getParameterClass())) {
            for (TableRowMO entry : this.entries.values()) {
                ((ManagedObjectSupport)((Object)entry)).validateUndeclaredConstraints(invalidValues);
            }
        }
    }

    protected final void validateDeclaredConstraints(List<InvalidValue> invalidValues) {
        for (TableRowMO entry : this.entries.values()) {
            this.addInvalidValues(invalidValues, this.initValidator(entry.getClass()).getInvalidValues((Object)entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transient
    public ClassValidator initValidator(Class<? extends TableRowMO> name) {
        Map<Class, ClassValidator> map = validators;
        synchronized (map) {
            ClassValidator result = validators.get(name);
            if (result == null) {
                ResourceBundle bundle = Internationalizer.getInternationalizer("com.bwanms.validator").asBundle();
                result = new ClassValidator(name, bundle);
                validators.put(name, result);
            }
            return result;
        }
    }

    private void addInvalidValues(List<InvalidValue> result, InvalidValue[] invalidValues) {
        for (InvalidValue value : invalidValues) {
            result.add(value);
        }
    }

    @Override
    public AbstractTableMO<T> clone() {
        try {
            ArrayList<TableRowMO> clonedEntries = new ArrayList<TableRowMO>();
            for (TableRowMO entry : this.getEntries()) {
                clonedEntries.add((TableRowMO)entry.clone());
            }
            AbstractTableMO ret = (AbstractTableMO)this.getClass().getConstructor(List.class).newInstance(clonedEntries);
            ret.setNRConfiguration(this.getNRConfiguration());
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRowKey() {
        return "0";
    }

    private class AbstractTableMOChangeStrategy
    implements ManagedObjectChangeStrategy {
        private AbstractTableMOChangeStrategy() {
        }

        public void acknowledge() {
            for (TableRowMO entry : AbstractTableMO.this.entries.values()) {
                entry.getChangeStrategy().acknowledge();
            }
            AbstractTableMO.this.newEntries.clear();
            AbstractTableMO.this.removedEntries().clear();
        }

        public boolean isChanged() {
            if (AbstractTableMO.this.newEntries.isEmpty() && AbstractTableMO.this.removedEntries().isEmpty()) {
                for (TableRowMO entry : AbstractTableMO.this.entries.values()) {
                    if (!entry.getChangeStrategy().isChanged()) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        public void reset() {
            for (String entryRowKey : AbstractTableMO.this.newEntries) {
                AbstractTableMO.this.entries.remove(entryRowKey);
            }
            for (TableRowMO entry : AbstractTableMO.this.removedEntries()) {
                AbstractTableMO.this.entries.put(entry.getRowKey(), entry);
            }
            for (TableRowMO entry : AbstractTableMO.this.entries.values()) {
                entry.getChangeStrategy().reset();
            }
            AbstractTableMO.this.newEntries.clear();
            AbstractTableMO.this.removedEntries().clear();
        }
    }
}

