/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.meta.mo;

import com.bwanms.meta.mo.MOChangeProcessor;
import com.bwanms.mo.ManagedObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOChangeProcessorUtil {
    private static final Logger log = Logger.getLogger(MOChangeProcessorUtil.class);

    public static Map<Class<? extends ManagedObject>, Method> getProcessors(Class processorsClass) {
        HashMap<Class<? extends ManagedObject>, Method> ret = new HashMap<Class<? extends ManagedObject>, Method>();
        for (Method method : processorsClass.getMethods()) {
            MOChangeProcessor annotation = method.getAnnotation(MOChangeProcessor.class);
            if (annotation == null) continue;
            if (ret.containsKey(annotation.moClass())) {
                throw new AssertionError((Object)("Duplicate MOChangeProcessor found for " + annotation.moClass().getName() + " in " + processorsClass.getName()));
            }
            log.debug((Object)("Registering [" + annotation.moClass().getName() + "] handler [" + method.getName() + "]"));
            ret.put(annotation.moClass(), method);
        }
        return ret;
    }
}

