/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.meta.filters;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.FiltersOn;
import com.bwanms.meta.filters.IFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.Map;

public class FilterEngine {
    private static final long serialVersionUID = -734296263995101223L;
    private Map<Class<? extends IFilter>, IFilter> filters = new HashMap<Class<? extends IFilter>, IFilter>();

    public boolean accept(Object annotatedElement, Object discriminator) {
        return this.acceptAttribute(annotatedElement, discriminator);
    }

    public boolean acceptAttribute(Object annotatedElement, Object discriminator) {
        Boolean result = false;
        if (annotatedElement != null) {
            Annotation[] annotations = this.getAnnotations(annotatedElement);
            result = null;
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    boolean res;
                    if (annotation instanceof Filter ? (result = this.addResult(result, res = this.accepted(discriminator, (Filter)annotation))) != false : annotation instanceof FiltersOn && (result = this.addResult(result, res = this.accepted(discriminator, (FiltersOn)annotation))) != false) break;
                }
            }
            if (result == null) {
                result = true;
            }
        }
        return result;
    }

    private Annotation[] getAnnotations(Object annotatedElement) {
        if (annotatedElement instanceof Class) {
            return ((Class)annotatedElement).getAnnotations();
        }
        if (annotatedElement instanceof AccessibleObject) {
            return ((AccessibleObject)annotatedElement).getAnnotations();
        }
        return null;
    }

    private Boolean addResult(Boolean result, boolean res) {
        result = result == null ? Boolean.valueOf(res) : Boolean.valueOf(result | res);
        return result;
    }

    public boolean accepted(Object discriminator, Filter filt) {
        boolean result = true;
        if (filt.on().isAssignableFrom(discriminator.getClass())) {
            try {
                result = this.getFilter(filt).accept(discriminator, filt.values());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean accepted(Object discriminator, FiltersOn on) {
        boolean res = true;
        for (Filter filter : on.filters()) {
            res &= this.accepted(discriminator, filter);
        }
        return res;
    }

    private IFilter getFilter(Filter filt) throws InstantiationException, IllegalAccessException {
        IFilter filter = this.filters.get(filt.filterClass());
        if (filter == null) {
            filter = filt.filterClass().newInstance();
            this.filters.put(filt.filterClass(), filter);
        }
        return filter;
    }
}

