/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.meta.filters;

import com.bwanms.meta.filters.AttributeFilter;
import com.bwanms.meta.filters.FilterEngine;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeFilterFactory {
    private static FilterEngine filterEngine = new FilterEngine();

    public static AttributeFilter createFilter(Object discriminator, Class targetClass) {
        ArrayList<String> matchingAttributes = new ArrayList<String>();
        for (Method method : BeanUtils.getPropertyGetters(targetClass)) {
            boolean accepted = filterEngine.accept(method, discriminator);
            if (!accepted) continue;
            matchingAttributes.add(BeanUtils.getPropertyNameFromGetter(method));
        }
        return new DefaultFilterImpl(matchingAttributes);
    }

    public static AttributeFilter intersect(AttributeFilter filter, List<String> includedAttributes) {
        ArrayList<String> matchingAttributes = new ArrayList<String>();
        for (String attribute : includedAttributes) {
            if (!filter.acceptAttribute(attribute)) continue;
            matchingAttributes.add(attribute);
        }
        return new DefaultFilterImpl(matchingAttributes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFilterImpl
    implements AttributeFilter {
        private static final long serialVersionUID = -3653811867903192928L;
        private List<String> matchingAttributes;

        public DefaultFilterImpl(List<String> matchingAttributes) {
            this.matchingAttributes = matchingAttributes;
        }

        @Override
        public boolean acceptAttribute(String attributeName) {
            return this.matchingAttributes.contains(attributeName);
        }
    }
}

