/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPMOAccessSession;
import com.bwanms.mediation.snmp.SNMPNetworkResourceHandler;
import com.bwanms.meta.snmp.SNMPScalarGroup;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.InstanceQuery;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.protocols.snmp.NullObject;
import com.bwanms.protocols.snmp.SNMPAgentErrorException;
import com.bwanms.protocols.snmp.SNMPException;
import com.bwanms.protocols.snmp.SNMPFactory;
import com.bwanms.protocols.snmp.SNMPSession;
import com.bwanms.protocols.snmp.SNMPTimeoutException;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNMPv2cMOAccessSession
extends SNMPMOAccessSession {
    private static final Logger logger = Logger.getLogger(SNMPv2cMOAccessSession.class);

    public SNMPv2cMOAccessSession(SNMPManagementInterface agentInfo, SNMPNetworkResourceHandler nrHandler) throws MediationException {
        super(agentInfo, nrHandler);
        logger.info((Object)"Created SNMPMOAccessSession");
    }

    @Override
    protected SNMPSession getSNMPSession(String networkResource) throws Exception {
        SNMPSession snmpSession = null;
        if (networkResource == null || this.nrHandler == null) {
            if (this.defaultSNMPSession == null) {
                this.defaultSNMPSession = SNMPFactory.createSession(this.agentInfo);
            }
            snmpSession = this.defaultSNMPSession;
        } else {
            snmpSession = (SNMPSession)this.snmpSessions.get(networkResource);
            if (snmpSession == null) {
                SNMPManagementInterface nrAgentInfo = this.nrHandler.getAgentInfo(this.agentInfo, networkResource);
                snmpSession = SNMPFactory.createSession(nrAgentInfo);
                this.snmpSessions.put(networkResource, snmpSession);
            }
        }
        return snmpSession;
    }

    @Override
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String instanceQuery) throws MediationException {
        long start = System.currentTimeMillis();
        List<Object> result = null;
        try {
            SNMPSession snmpSession = this.getSNMPSession(networkResource);
            if (!this.isTable(moClass) && !this.isScalar(moClass)) {
                throw new IllegalArgumentException("[" + moClass + "] is not a SNMP managed object class");
            }
            InstanceQuery query = new InstanceQuery(instanceQuery);
            switch (query.getQueryType()) {
                case 1: {
                    if (this.isTable(moClass)) {
                        result = this.fetchTable(snmpSession, moClass, includedProperties, null, false);
                        break;
                    }
                    if (!this.isScalar(moClass)) break;
                    result = this.fetchScalarGroup(snmpSession, moClass, includedProperties);
                    break;
                }
                case 2: 
                case 4: {
                    if (this.isTable(moClass)) {
                        result = this.fetchTable(snmpSession, moClass, includedProperties, query.getPrefix(), false);
                        break;
                    }
                    throw new IllegalArgumentException("[" + moClass + "] is not a SNMP table entry class");
                }
                case 3: {
                    String[] instances = query.getInstances();
                    if (this.isTable(moClass)) {
                        result = this.fetchTableRows(snmpSession, moClass, includedProperties, instances);
                        break;
                    }
                    if (!this.isScalar(moClass)) break;
                    if (instances.length == 1 && "0".equals(instances[0])) {
                        result = this.fetchScalarGroup(snmpSession, moClass, includedProperties);
                        break;
                    }
                    throw new IllegalArgumentException("[" + instanceQuery + "] does not match SNMP scalar instance");
                }
            }
            if (result == null) {
                result = new ArrayList();
            }
            this.setTimeStamp(result, System.currentTimeMillis());
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (SNMPTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (SNMPAgentErrorException e) {
            throw new AgentException(e);
        }
        catch (SNMPException e) {
            if (e.getCause() instanceof IOException) {
                throw new CommunicationException(e);
            }
            throw new MediationException(e);
        }
        catch (Exception x) {
            throw new MediationException("Error on fetching managed object of type [" + moClass + "].", x);
        }
        finally {
            long spent = System.currentTimeMillis() - start;
            time += spent;
        }
    }

    private <T> List<T> fetchScalarGroup(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties) throws Exception {
        ArrayList<T> result = new ArrayList<T>(1);
        VarBindList varBindList = this.makeVarbindListForGet(moClass, null, includedProperties);
        if (varBindList.size() > 0) {
            snmpSession.get(varBindList);
            result.add(this.makeManagedObject(moClass, varBindList));
        }
        return result;
    }

    private <T> List<T> fetchTable(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties, String startingInstance, boolean bulk) throws Exception {
        ArrayList<T> result = new ArrayList<T>(1);
        SNMPTableEntry entryMeta = moClass.getAnnotation(SNMPTableEntry.class);
        VarBindList varBindList = this.makeVarbindListForGet(moClass, startingInstance, includedProperties);
        if (varBindList.size() > 0) {
            int baseOIDIdx = -1;
            for (int i = 0; i < varBindList.size() && baseOIDIdx == -1; ++i) {
                if (!varBindList.get(i).getOID().startsWith(entryMeta.entryOID())) continue;
                baseOIDIdx = i;
            }
            if (baseOIDIdx == -1) {
                throw new RuntimeException("Malformed Table MO - does not contain any table entries");
            }
            String baseOID = varBindList.get(baseOIDIdx).getOID();
            boolean endoftable = false;
            while (!endoftable) {
                for (VarBind vb : varBindList) {
                    vb.setVariable(null);
                }
                snmpSession.getNext(varBindList);
                if (varBindList.size() > 0 && varBindList.get(baseOIDIdx).getOID().startsWith(baseOID)) {
                    for (VarBind vb : varBindList) {
                        Object var = vb.getVariable();
                        if (var instanceof NullObject) {
                            NullObject exp = (NullObject)var;
                            if (!exp.isException()) continue;
                            endoftable = true;
                            continue;
                        }
                        switch (vb.getType()) {
                            case 128: 
                            case 129: 
                            case 130: {
                                endoftable = true;
                            }
                        }
                    }
                    if (endoftable) continue;
                    result.add(this.makeManagedObject(moClass, varBindList));
                    continue;
                }
                endoftable = true;
            }
        }
        return result;
    }

    private <T> List<T> fetchTableRows(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties, String[] instances) throws Exception {
        ArrayList<T> result = new ArrayList<T>(instances.length);
        for (String instance : instances) {
            VarBindList varBindList = this.makeVarbindListForGet(moClass, instance, includedProperties);
            if (varBindList.size() <= 0) continue;
            snmpSession.get(varBindList);
            result.add(this.makeManagedObject(moClass, varBindList));
        }
        return result;
    }

    private boolean isTable(Class<?> moClass) {
        return moClass.getAnnotation(SNMPTableEntry.class) != null;
    }

    private boolean isScalar(Class<?> moClass) {
        return moClass.getAnnotation(SNMPScalarGroup.class) != null || ScalarMO.class.isAssignableFrom(moClass);
    }
}

