/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.protocols.snmp.SNMPTrapV1;

public class SNMPTrapV1AgentEvent
extends SNMPTrapAgentEvent {
    private String agentIPAddress;
    private String enterpriseOID;
    private int generic;
    private int specific;
    private long timestamp;

    public SNMPTrapV1AgentEvent(SNMPTrapV1 trapV1) {
        this(trapV1, false);
    }

    public SNMPTrapV1AgentEvent(SNMPTrapV1 trapV1, boolean recoveredTrap) {
        super(trapV1, recoveredTrap);
        this.agentIPAddress = trapV1.getAgentIPAddress();
        this.enterpriseOID = trapV1.getEnterpriseOID();
        this.generic = trapV1.getGeneric();
        this.specific = trapV1.getSpecific();
        this.timestamp = trapV1.getTimestamp();
    }

    public String getAgentIPAddress() {
        return this.agentIPAddress;
    }

    public String getEnterpriseOID() {
        return this.enterpriseOID;
    }

    public int getGeneric() {
        return this.generic;
    }

    public int getSpecific() {
        return this.specific;
    }

    public String getAgentKey() {
        return this.agentIPAddress;
    }

    public long getAgentEventTimestamp() {
        return this.getTimestamp();
    }

    public String getSnmpTrapOID() {
        StringBuffer oid = new StringBuffer(this.enterpriseOID);
        if (this.generic == 6) {
            oid.append(".0.").append(this.specific);
        } else {
            oid.append(".").append(this.generic);
        }
        return oid.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

