/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.mediation.snmp.SNMPAutoDiscoveryEntry;
import com.bwanms.mediation.snmp.SNMPTrapIpFloodingEntry;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNMPTrapFilter {
    private static final Logger log = Logger.getLogger(SNMPTrapFilter.class);
    private static final boolean ANTIFLOODING_ENABLED = false;
    private static final long ANTIFLOODING_TRAPCOUNT = 100L;
    private static final long ANTIFLOODING_COUNTING_INTERVAL = 1000L;
    private static final long ANTIFLOODING_BLOCKING_INTERVAL = 60000L;
    private static final boolean AUTODISCOVERY_ENABLED = true;
    private static final long AUTODISCOVERY_RETRY_INTERVAL = 600000L;
    private static boolean antiFloodingEnabled = false;
    private static long ipFloodingTrapsCountingPerIP = 100L;
    private static long ipFloodingTrapsCountingInterval = 1000L;
    private static long ipFloodingBlockInterval = 60000L;
    private static boolean autoDiscoveryEnabled = true;
    private static long autoDiscoveryRetryInterval = 600000L;
    private static String[] oids;
    private static Map<String, SNMPAutoDiscoveryEntry> autoDiscoveryMap;
    private static Map<String, SNMPTrapIpFloodingEntry> ipFloodingMap;

    public static Map<String, SNMPAutoDiscoveryEntry> getAutoDiscoveryMap() {
        return autoDiscoveryMap;
    }

    public static boolean acceptV1Trap(PDUv1 pdu) {
        try {
            String oid = pdu.getEnterprise().toString();
            String ip = pdu.getAgentAddress().toString();
            return SNMPTrapFilter.acceptOID(oid) && SNMPTrapFilter.acceptAutodiscoverIP(ip) && SNMPTrapFilter.acceptFloodingIP(ip);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean acceptTrap(PDU pdu, String ip) {
        try {
            VariableBinding vb = (VariableBinding)pdu.getVariableBindings().get(1);
            String oid = ((OID)vb.getVariable()).toString();
            return SNMPTrapFilter.acceptOID(oid) && SNMPTrapFilter.acceptAutodiscoverIP(ip) && SNMPTrapFilter.acceptFloodingIP(ip);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    private static boolean acceptOID(String oid) {
        try {
            for (String acceptedOid : oids) {
                if (!oid.startsWith(acceptedOid)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private static boolean acceptAutodiscoverIP(String ip) {
        autoDiscoveryEnabled = SystemPropertyUtil.getBoolean("com.bwanms.autodiscovery.enabled", "true", true);
        autoDiscoveryRetryInterval = SystemPropertyUtil.getLong("com.bwanms.autodiscovery.retryInterval", 600000L);
        if (autoDiscoveryEnabled) {
            try {
                SNMPAutoDiscoveryEntry entry = autoDiscoveryMap.get(ip);
                return entry == null || System.currentTimeMillis() - entry.getLastAttemptTime() >= autoDiscoveryRetryInterval;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean acceptFloodingIP(String ip) {
        antiFloodingEnabled = SystemPropertyUtil.getBoolean("com.bwanms.antiflooding.enabled", "true", false);
        ipFloodingTrapsCountingPerIP = SystemPropertyUtil.getLong("com.bwanms.antiflooding.trapCount", 100L);
        ipFloodingTrapsCountingInterval = SystemPropertyUtil.getLong("com.bwanms.antiflooding.countingInterval", 1000L);
        ipFloodingBlockInterval = SystemPropertyUtil.getLong("com.bwanms.antiflooding.blockingInterval", 60000L);
        if (antiFloodingEnabled) {
            try {
                SNMPTrapIpFloodingEntry entry = ipFloodingMap.get(ip);
                if (entry != null) {
                    if (entry.getFirstTrapTime() > System.currentTimeMillis()) {
                        return false;
                    }
                    entry.incrementTrapsCount();
                    if (entry.getTrapsCount() == 1) {
                        entry.setFirstTrapTime(System.currentTimeMillis());
                    } else if ((long)entry.getTrapsCount() > ipFloodingTrapsCountingPerIP) {
                        entry.setTrapsCount(0);
                        if (System.currentTimeMillis() - entry.getFirstTrapTime() < ipFloodingTrapsCountingInterval) {
                            entry.setFirstTrapTime(System.currentTimeMillis() + ipFloodingBlockInterval);
                            return false;
                        }
                    }
                } else {
                    entry = new SNMPTrapIpFloodingEntry(ip, System.currentTimeMillis(), 1);
                    ipFloodingMap.put(ip, entry);
                }
                return true;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return true;
            }
        }
        return true;
    }

    static {
        ArrayList<String> tempOids = new ArrayList<String>();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.SNMPTrapFilter");
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                if (tempOids.contains(element.getAttribute("oid"))) continue;
                tempOids.add(element.getAttribute("oid"));
            }
            try {
                oids = new String[tempOids.size()];
                oids = tempOids.toArray(oids);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        autoDiscoveryMap = new Hashtable<String, SNMPAutoDiscoveryEntry>();
        ipFloodingMap = new Hashtable<String, SNMPTrapIpFloodingEntry>();
    }
}

