/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.mediation.services.AgentEventProcessorManager;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.protocols.snmp.SNMPFactory;
import com.bwanms.protocols.snmp.SNMPTrap;
import com.bwanms.protocols.snmp.SNMPTrapListener;
import com.bwanms.protocols.snmp.SNMPTrapProcessor;
import com.bwanms.protocols.snmp.SNMPTrapV1;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class SNMPTrapAgentEventNetworkListener
implements Runnable,
SNMPTrapProcessor {
    private static final Logger logger = Logger.getLogger(SNMPTrapAgentEventNetworkListener.class);
    private SNMPTrapListener listener = null;
    private String ipAddress = "0.0.0.0";
    private int maxBatchSize = 2000;
    private int batchInterval = 500;
    private int port = 162;
    private long messageTTL = 180000L;
    private Thread senderThread;
    private AtomicBoolean shouldStop;
    AgentEventProcessorManager agentEventProcessorManager;
    private BlockingQueue<SNMPTrapAgentEvent> eventList = new LinkedBlockingQueue<SNMPTrapAgentEvent>();

    public void start() throws IOException {
        logger.info((Object)("Starting listener on " + this.ipAddress + "/" + this.port));
        this.listener = "0.0.0.0".equals(this.ipAddress) ? SNMPFactory.createTrapListener(this.port) : SNMPFactory.createTrapListener(this.ipAddress, this.port);
        this.listener.addSNMPTrapProcessor(this);
        this.shouldStop = new AtomicBoolean(false);
        this.agentEventProcessorManager = (AgentEventProcessorManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/AgentEventProcessorManager");
        this.senderThread = new Thread(this);
        this.senderThread.start();
    }

    public void stop() {
        if (this.listener != null) {
            this.listener.close();
        }
        this.shouldStop.set(true);
        this.senderThread = null;
    }

    private synchronized void addTrap(SNMPTrap trap) {
        SNMPTrapAgentEvent agentEvent = null;
        agentEvent = trap instanceof SNMPTrapV1 ? new SNMPTrapV1AgentEvent((SNMPTrapV1)trap) : new SNMPTrapAgentEvent(trap);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trap : " + trap.toString()));
        }
        this.eventList.add(agentEvent);
        if (this.eventList.size() > this.maxBatchSize) {
            this.sendBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch() {
        BlockingQueue<SNMPTrapAgentEvent> blockingQueue = this.eventList;
        synchronized (blockingQueue) {
            SNMPTrapAgentEvent evt;
            for (int remainingEvents = this.eventList.size(); remainingEvents > 0 && (evt = (SNMPTrapAgentEvent)this.eventList.poll()) != null; --remainingEvents) {
                this.agentEventProcessorManager.add(evt);
            }
        }
    }

    public void process(SNMPTrap trap) {
        logger.debug((Object)("Trap received [" + trap + "]"));
        this.addTrap(trap);
    }

    public void run() {
        logger.debug((Object)"Sender thread starting");
        while (!this.shouldStop.get()) {
            this.sendBatch();
            try {
                Thread.sleep(this.batchInterval);
            }
            catch (InterruptedException e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
        logger.debug((Object)"Sender thread stop");
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatch) {
        this.maxBatchSize = maxBatch;
    }

    public int getBatchInterval() {
        return this.batchInterval;
    }

    public void setBatchInterval(int batchInterval) {
        this.batchInterval = batchInterval;
    }

    public void setMessageTTL(long messageTTL) {
        this.messageTTL = messageTTL;
    }

    public long getMessageTTL() {
        return this.messageTTL;
    }
}

