/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.model.AgentEvent;
import com.bwanms.protocols.snmp.SNMPTrap;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.OctetString;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNMPTrapAgentEvent
implements AgentEvent {
    private static final long serialVersionUID = 3765812727157088194L;
    private String agentKey;
    private VarBindList varBindList;
    private long receivedTime;
    private boolean recoveredTrap = false;

    public SNMPTrapAgentEvent(SNMPTrap trap) {
        this(trap, false);
    }

    public SNMPTrapAgentEvent(SNMPTrap trap, boolean recoveredTrap) {
        this.varBindList = trap.getVarBindList();
        this.receivedTime = trap.getReceivedTime();
        this.agentKey = trap.getAgentAddress();
        this.recoveredTrap = recoveredTrap;
    }

    @Override
    public String getAgentKey() {
        return this.agentKey;
    }

    @Override
    public long getAgentEventTimestamp() {
        VarBind vbTimestamp = this.varBindList.get(0);
        return (Long)vbTimestamp.getVariable();
    }

    public String getSnmpTrapOID() {
        VarBind vbSnmpTrapOid = this.varBindList.get(1);
        return vbSnmpTrapOid.getVariable().toString();
    }

    @Override
    public long getReceivedTime() {
        return this.receivedTime;
    }

    public VarBindList getVarBindList() {
        return this.varBindList;
    }

    public boolean isRecoveredTrap() {
        return this.recoveredTrap;
    }

    public void setRecoveredTrap(boolean recoveredTrap) {
        this.recoveredTrap = recoveredTrap;
    }

    public String toString() {
        return this.varBindList.toString();
    }

    public <T> T createDataObject(Class<T> dataObjectClass) {
        try {
            T dataObject = dataObjectClass.newInstance();
            for (Method method : BeanUtils.getPropertyGetters(dataObjectClass)) {
                VarBind vb;
                SNMPParameter snmpInfo = method.getAnnotation(SNMPParameter.class);
                if (snmpInfo == null || (vb = this.varBindList.findVarBindwithInstanceByOID(snmpInfo.OID())) == null) continue;
                String setterName = "set" + method.getName().substring(3);
                Method setter = dataObjectClass.getMethod(setterName, method.getReturnType());
                try {
                    Object value = this.processType(snmpInfo, vb.getVariable());
                    setter.invoke(dataObject, value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't asign value (" + vb.getVariable().getClass() + ")" + vb.getVariable() + " " + " through setter " + setter.getName() + "(" + setter.getParameterTypes()[0] + ")", e);
                }
            }
            return dataObject;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object processType(SNMPParameter snmpParam, Object varBindValue) {
        if (snmpParam.type() == -128) {
            return OctetString.toDisplayString((String)varBindValue);
        }
        if (snmpParam.type() == 66) {
            return ((Number)varBindValue).longValue();
        }
        return varBindValue;
    }
}

