/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MOAccessSessionFactory;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.snmp.SNMPMOAccessSession;
import com.bwanms.mediation.snmp.SNMPNetworkResourceHandler;
import com.bwanms.mediation.snmp.SNMPv2cMOAccessSession;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;

public class SNMPMOAccessSessionFactory
implements MOAccessSessionFactory {
    private static SNMPMOAccessSessionFactory instance = null;

    private SNMPMOAccessSessionFactory() {
    }

    public static SNMPMOAccessSessionFactory getInstance() {
        if (instance == null) {
            instance = new SNMPMOAccessSessionFactory();
        }
        return instance;
    }

    public MOAccessSession createAccessSession(ManagementInterface mgmtInfo, NetworkResourceHandler nrHandler) throws MediationException {
        if (!(mgmtInfo instanceof SNMPManagementInterface)) {
            throw new IllegalArgumentException("Not SNMPManagementInterface instance or null");
        }
        if (nrHandler != null && !(nrHandler instanceof SNMPNetworkResourceHandler)) {
            throw new IllegalArgumentException("Not SNMPNetworkResourceHandler instance");
        }
        SNMPManagementInterface agentInfo = (SNMPManagementInterface)mgmtInfo;
        switch (agentInfo.getVersion()) {
            case 0: {
                return new SNMPMOAccessSession(agentInfo, (SNMPNetworkResourceHandler)nrHandler);
            }
            case 1: {
                return new SNMPv2cMOAccessSession(agentInfo, (SNMPNetworkResourceHandler)nrHandler);
            }
            case 3: {
                throw new UnsupportedOperationException("SNMPv3 not supported yet");
            }
        }
        throw new RuntimeException("Unknown SNMP version");
    }
}

