/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.snmp;

import com.bwanms.mediation.AbstractMOAccessSession;
import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPNetworkResourceHandler;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.protocols.Protocol;
import com.bwanms.protocols.snmp.NullObject;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.protocols.snmp.SNMPAgentErrorException;
import com.bwanms.protocols.snmp.SNMPException;
import com.bwanms.protocols.snmp.SNMPFactory;
import com.bwanms.protocols.snmp.SNMPSession;
import com.bwanms.protocols.snmp.SNMPTimeoutException;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.MacAddress;
import com.bwanms.util.OctetString;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNMPMOAccessSession
extends AbstractMOAccessSession {
    private static final Logger logger = Logger.getLogger(SNMPMOAccessSession.class);
    public static long time;
    protected SNMPManagementInterface agentInfo = null;
    protected SNMPSession defaultSNMPSession = null;
    protected SNMPNetworkResourceHandler nrHandler;
    protected HashMap<String, SNMPSession> snmpSessions = new HashMap();

    public SNMPMOAccessSession(SNMPManagementInterface agentInfo, SNMPNetworkResourceHandler nrHandler) throws MediationException {
        this.agentInfo = agentInfo;
        this.nrHandler = nrHandler;
    }

    protected SNMPSession getSNMPSession(String networkResource) throws Exception {
        SNMPSession snmpSession = null;
        if (networkResource == null || this.nrHandler == null) {
            if (this.defaultSNMPSession == null) {
                this.defaultSNMPSession = SNMPFactory.createSession(this.agentInfo);
            }
            snmpSession = this.defaultSNMPSession;
        } else {
            snmpSession = this.snmpSessions.get(networkResource);
            if (snmpSession == null) {
                SNMPManagementInterface nrAgentInfo = this.nrHandler.getAgentInfo(this.agentInfo, networkResource);
                snmpSession = SNMPFactory.createSession(nrAgentInfo);
                this.snmpSessions.put(networkResource, snmpSession);
            }
        }
        return snmpSession;
    }

    @Override
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String instanceQuery) throws MediationException {
        if (instanceQuery == null || instanceQuery.length() == 0 || instanceQuery.equals("*")) {
            return this.fetchObjectInstances(networkResource, moClass, includedProperties, null);
        }
        if (instanceQuery.endsWith("*")) {
            String instancePrefix = instanceQuery.substring(0, instanceQuery.length() - 1);
            if (instancePrefix.endsWith(".")) {
                instancePrefix = instancePrefix.substring(0, instancePrefix.length() - 1);
            }
            return this.fetchObjectStar(networkResource, moClass, includedProperties, instancePrefix);
        }
        if (instanceQuery.endsWith("+")) {
            return this.fetchObjectPlus(networkResource, moClass, includedProperties, instanceQuery.substring(0, instanceQuery.length() - 1));
        }
        if (instanceQuery.indexOf("+") > -1 || instanceQuery.indexOf("*") > -1) {
            throw new AssertionError((Object)("Wrong instance query format: " + instanceQuery));
        }
        String[] instances = instanceQuery.split(",");
        return this.fetchObjectInstances(networkResource, moClass, includedProperties, instances);
    }

    @Override
    @Deprecated
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String[] instances) throws MediationException {
        return this.fetchObjectInstances(networkResource, moClass, includedProperties, instances);
    }

    protected <T> List<T> fetchObjectInstances(String networkResource, Class<T> moClass, String[] includedProperties, String[] instances) throws MediationException {
        long start = System.currentTimeMillis();
        ArrayList<T> ret = new ArrayList<T>();
        try {
            SNMPSession snmpSession = this.getSNMPSession(networkResource);
            if (moClass.getAnnotation(SNMPTableEntry.class) != null) {
                if (instances == null) {
                    ret.addAll(this.fetchObjectTable(snmpSession, moClass, includedProperties, null));
                } else {
                    ret.addAll(this.fetchTableEntries(snmpSession, moClass, includedProperties, instances));
                }
            } else {
                ret.add(this.fetchScalarObject(snmpSession, moClass, includedProperties));
            }
            this.setTimeStamp(ret, System.currentTimeMillis());
            ArrayList<T> arrayList = ret;
            return arrayList;
        }
        catch (SNMPTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (SNMPAgentErrorException e) {
            throw new AgentException(e);
        }
        catch (SNMPException e) {
            if (e.getCause() instanceof IOException) {
                throw new CommunicationException(e);
            }
            throw new MediationException(e);
        }
        catch (Exception x) {
            throw new MediationException("Error on fetching managed object of type [" + moClass + "].", x);
        }
        finally {
            long spent = System.currentTimeMillis() - start;
            time += spent;
        }
    }

    protected <T> List<T> fetchObjectPlus(String networkResource, Class<T> moClass, String[] includedProperties, String startingInstance) throws MediationException {
        long start = System.currentTimeMillis();
        ArrayList<T> ret = new ArrayList<T>();
        try {
            SNMPSession snmpSession = this.getSNMPSession(networkResource);
            if (moClass.getAnnotation(SNMPTableEntry.class) != null) {
                ret.addAll(this.fetchObjectTable(snmpSession, moClass, includedProperties, startingInstance));
            } else {
                ret.add(this.fetchScalarObject(snmpSession, moClass, includedProperties));
            }
            this.setTimeStamp(ret, System.currentTimeMillis());
            ArrayList<T> arrayList = ret;
            return arrayList;
        }
        catch (SNMPTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (SNMPAgentErrorException e) {
            throw new AgentException(e);
        }
        catch (SNMPException e) {
            if (e.getCause() instanceof IOException) {
                throw new CommunicationException(e);
            }
            throw new MediationException(e);
        }
        catch (Exception x) {
            throw new MediationException("Error on fetching managed object of type [" + moClass + "].", x);
        }
        finally {
            long spent = System.currentTimeMillis() - start;
            time += spent;
        }
    }

    protected <T> List<T> fetchObjectStar(String networkResource, Class<T> moClass, String[] includedProperties, String instancePrefix) throws MediationException {
        long start = System.currentTimeMillis();
        ArrayList<T> ret = new ArrayList<T>();
        try {
            SNMPSession snmpSession = this.getSNMPSession(networkResource);
            if (moClass.getAnnotation(SNMPTableEntry.class) != null) {
                ret.addAll(this.fetchObjectTableStar(snmpSession, moClass, includedProperties, instancePrefix));
            } else {
                ret.add(this.fetchScalarObject(snmpSession, moClass, includedProperties));
            }
            this.setTimeStamp(ret, System.currentTimeMillis());
            ArrayList<T> arrayList = ret;
            return arrayList;
        }
        catch (SNMPTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (SNMPAgentErrorException e) {
            throw new AgentException(e);
        }
        catch (SNMPException e) {
            if (e.getCause() instanceof IOException) {
                throw new CommunicationException(e);
            }
            throw new MediationException(e);
        }
        catch (Exception x) {
            throw new MediationException("Error on fetching managed object of type [" + moClass + "].", x);
        }
        finally {
            long spent = System.currentTimeMillis() - start;
            time += spent;
        }
    }

    private <T> List<T> fetchObjectTableStar(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties, String instancePrefix) throws Exception {
        ArrayList<T> ret = new ArrayList<T>();
        SNMPTableEntry entryMeta = moClass.getAnnotation(SNMPTableEntry.class);
        VarBindList vbList = this.makeVarbindListForGet(moClass, null, includedProperties);
        VarBindList varBindListForGet = null;
        if (instancePrefix != null) {
            varBindListForGet = new VarBindList();
            for (VarBind varBind : vbList) {
                varBindListForGet.add(new VarBind(varBind.getName(), varBind.getOID() + "." + instancePrefix, varBind.getType(), null));
            }
        } else {
            varBindListForGet = vbList;
        }
        if (vbList.size() > 0) {
            int baseOIDIdx = -1;
            for (int i = 0; i < vbList.size() && baseOIDIdx == -1; ++i) {
                if (!vbList.get(i).getOID().startsWith(entryMeta.entryOID())) continue;
                baseOIDIdx = i;
            }
            if (baseOIDIdx == -1) {
                throw new RuntimeException("Malformed Table MO - does not contain any table entries");
            }
            String baseOID = vbList.get(baseOIDIdx).getOID();
            boolean endoftable = false;
            while (!endoftable) {
                for (VarBind vb : varBindListForGet) {
                    vb.setVariable(null);
                }
                snmpSession.getNext(varBindListForGet);
                if (varBindListForGet.size() > 0 && varBindListForGet.get(baseOIDIdx).getOID().startsWith(baseOID + "." + instancePrefix)) {
                    ret.add(this.makeManagedObject(moClass, varBindListForGet));
                    continue;
                }
                endoftable = true;
            }
        }
        return ret;
    }

    private <T> T fetchScalarObject(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties) throws Exception {
        VarBindList varBindList = this.makeVarbindListForGet(moClass, null, includedProperties);
        snmpSession.get(varBindList);
        return this.makeManagedObject(moClass, varBindList);
    }

    private <T> List<T> fetchTableEntries(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties, String[] instances) throws Exception {
        ArrayList<T> ret = new ArrayList<T>();
        VarBindList varBindList = this.makeVarbindListForGet(moClass, null, includedProperties);
        if (varBindList.size() > 0) {
            for (String instance : instances) {
                VarBindList instanceVbList = new VarBindList();
                for (VarBind varBind : varBindList) {
                    instanceVbList.add(new VarBind(varBind.getName(), varBind.getOID() + "." + instance, varBind.getType(), null));
                }
                snmpSession.get(instanceVbList);
                ret.add(this.makeManagedObject(moClass, instanceVbList));
            }
        }
        return ret;
    }

    private <T> List<T> fetchObjectTable(SNMPSession snmpSession, Class<T> moClass, String[] includedProperties, String startingInstance) throws Exception {
        ArrayList<T> ret = new ArrayList<T>();
        SNMPTableEntry entryMeta = moClass.getAnnotation(SNMPTableEntry.class);
        VarBindList vbList = this.makeVarbindListForGet(moClass, null, includedProperties);
        VarBindList varBindListForGet = null;
        if (startingInstance != null) {
            varBindListForGet = new VarBindList();
            for (VarBind varBind : vbList) {
                varBindListForGet.add(new VarBind(varBind.getName(), varBind.getOID() + "." + startingInstance, varBind.getType(), null));
            }
        } else {
            varBindListForGet = vbList;
        }
        if (vbList.size() > 0) {
            int baseOIDIdx = -1;
            for (int i = 0; i < vbList.size() && baseOIDIdx == -1; ++i) {
                if (!vbList.get(i).getOID().startsWith(entryMeta.entryOID())) continue;
                baseOIDIdx = i;
            }
            if (baseOIDIdx == -1) {
                throw new RuntimeException("Malformed Table MO - does not contain any table entries");
            }
            String baseOID = vbList.get(baseOIDIdx).getOID();
            boolean endoftable = false;
            while (!endoftable) {
                for (VarBind vb : varBindListForGet) {
                    vb.setVariable(null);
                }
                snmpSession.getNext(varBindListForGet);
                if (varBindListForGet.size() > 0 && varBindListForGet.get(baseOIDIdx).getOID().startsWith(baseOID)) {
                    ret.add(this.makeManagedObject(moClass, varBindListForGet));
                    continue;
                }
                endoftable = true;
            }
        }
        return ret;
    }

    protected void setTimeStamp(Object mo, long timeStamp) {
        try {
            Method setter = mo.getClass().getMethod("setTimestamp", Long.class);
            setter.invoke(mo, new Long(timeStamp));
        }
        catch (NoSuchMethodException e) {
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T makeManagedObject(Class<T> moClass, VarBindList vblist) throws Exception {
        T mo = moClass.newInstance();
        Method[] methods = moClass.getMethods();
        String rowInstance = null;
        for (Method method : BeanUtils.getPropertyGetters(moClass)) {
            String setterName;
            Method setter;
            SNMPParameter snmpInfo = method.getAnnotation(SNMPParameter.class);
            if (snmpInfo == null) continue;
            Class<?> propType = method.getReturnType();
            VarBind vb = vblist.findVarBindwithInstanceByOID(snmpInfo.OID());
            if (vb == null) continue;
            if (rowInstance == null) {
                rowInstance = snmpInfo.OID().length() < vb.getOID().length() ? vb.getOID().substring(snmpInfo.OID().length() + 1) : null;
            }
            if ((setter = moClass.getMethod(setterName = "set" + method.getName().substring(3), propType)) == null) {
                throw new Exception("Can't find setter [" + setter + "] in class " + moClass.getName());
            }
            try {
                if (vb.getVariable() instanceof NullObject) continue;
                setter.invoke(mo, vb.getVariable());
            }
            catch (IllegalArgumentException e) {
                setter.invoke(mo, 1);
                logger.error((Object)String.format("Set fake value on %s [%s] - expected snmp type %s, var type %s", vb.getName(), moClass.getName(), VarBind.getTypeName(vb.getType()), vb.getVariable().getClass().getName()));
            }
            catch (Exception e) {
                throw new RuntimeException("Can't asign value (" + vb.getVariable().getClass().getName() + ") " + vb.getVariable() + " through setter " + setter.getName() + "(" + setter.getParameterTypes()[0] + ")", e);
            }
        }
        SNMPTableEntry snmpEntryInfo = moClass.getAnnotation(SNMPTableEntry.class);
        if (snmpEntryInfo != null && vblist.size() > 0) {
            try {
                Method instanceSetter = moClass.getMethod("setInstance", String.class);
                instanceSetter.invoke(mo, rowInstance);
            }
            catch (Exception e) {
                logger.debug((Object)("Could not set instance on: " + moClass.getName()));
            }
            StringBuilder s = new StringBuilder(rowInstance);
            for (String index : snmpEntryInfo.indexColumns()) {
                Method setter = null;
                Method getter = null;
                for (Method method : methods) {
                    if (method.getName().equals("set" + index)) {
                        setter = method;
                    }
                    if (!method.getName().equals("get" + index)) continue;
                    getter = method;
                }
                if (getter == null || setter == null) {
                    throw new RuntimeException("Missing getter or setter for index property: " + index + " in class " + moClass.getName());
                }
                SNMPParameter snmpInfo = getter.getAnnotation(SNMPParameter.class);
                if (snmpInfo == null) {
                    throw new RuntimeException("Missing SNMPParameter annotation for index property: " + getter + " in class " + moClass.getName());
                }
                Object value = this.getNextValueFromRowInstance(s, snmpInfo.type());
                if (value == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting index: " + moClass.getName() + " " + setter.getName() + " " + value));
                }
                setter.invoke(mo, value);
            }
        }
        return mo;
    }

    private static String getNextInstanceParts(StringBuilder rowInstance, int partCount) throws MediationException {
        String[] ret = rowInstance.toString().split("\\.", partCount + 1);
        if (ret.length < partCount) {
            throw new MediationException("Invalid instance. Found: " + rowInstance.toString());
        }
        if (ret.length > partCount) {
            rowInstance.setLength(0);
            rowInstance.append(ret[partCount]);
        }
        String[] s = ret;
        StringBuilder ret1 = new StringBuilder(s[0]);
        for (int i = 1; i < partCount; ++i) {
            ret1.append('.');
            ret1.append(s[i]);
        }
        return ret1.toString();
    }

    private Object getNextValueFromRowInstance(StringBuilder rowInstance, int type) throws MediationException {
        switch (type) {
            case 2: 
            case 65: 
            case 66: 
            case 70: {
                return SNMPMOAccessSession.fromSNMPInstance(SNMPMOAccessSession.getNextInstanceParts(rowInstance, 1), type);
            }
            case 112: {
                return SNMPMOAccessSession.fromSNMPInstance(SNMPMOAccessSession.getNextInstanceParts(rowInstance, 6), type);
            }
            case 64: {
                return SNMPMOAccessSession.fromSNMPInstance(SNMPMOAccessSession.getNextInstanceParts(rowInstance, 4), type);
            }
            case -128: 
            case 4: {
                String[] rowInstanceSplit = rowInstance.toString().split("\\.");
                rowInstance = new StringBuilder(rowInstance.substring(rowInstance.indexOf(".") + 1));
                return SNMPMOAccessSession.fromSNMPInstance(SNMPMOAccessSession.getNextInstanceParts(rowInstance, Integer.parseInt(rowInstanceSplit[0])), type);
            }
        }
        throw new RuntimeException("Can't handle index type: " + type);
    }

    @Override
    public void close() {
        if (this.defaultSNMPSession != null) {
            try {
                this.defaultSNMPSession.close();
            }
            catch (Exception e) {
                logger.error((Object)"Could not close SNMP Session", (Throwable)e);
            }
        }
        for (SNMPSession snmpSession : this.snmpSessions.values()) {
            try {
                snmpSession.close();
            }
            catch (Exception e) {
                logger.error((Object)"Could not close SNMP Session", (Throwable)e);
            }
        }
    }

    @Override
    public void commitObject(String networkResource, Object object, String[] includedProperties) throws MediationException {
        try {
            ArrayList<VarBindList> vbLists = new ArrayList<VarBindList>();
            VarBindList varBindList = this.makeVarbindListForSet(object, includedProperties);
            vbLists.add(varBindList);
            SNMPSession snmpSession = this.getSNMPSession(networkResource);
            for (VarBindList vbList : vbLists) {
                if (vbList.isEmpty()) continue;
                snmpSession.set(vbList);
            }
        }
        catch (SNMPTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (SNMPAgentErrorException e) {
            throw new AgentException(e);
        }
        catch (SNMPException e) {
            if (e.getCause() instanceof IOException) {
                throw new CommunicationException(e);
            }
            throw new MediationException(e);
        }
        catch (Exception x) {
            throw new MediationException(x);
        }
    }

    private static String toInstanceString(Method getter, Object value) throws MediationException {
        SNMPParameter snmpInfo = getter.getAnnotation(SNMPParameter.class);
        if (snmpInfo == null) {
            throw new RuntimeException("Missing SNMPParameter annotation for index property: " + getter.getName());
        }
        switch (snmpInfo.type()) {
            case 112: {
                return MacAddress.fromOctetString((String)value).toInstanceString();
            }
            case -128: {
                value = OctetString.toDottedDecimalForm(OctetString.fromDisplayString((String)value));
            }
            case 4: {
                int stringLength = value.toString().split("\\.").length;
                return stringLength + "." + value.toString();
            }
        }
        return value.toString();
    }

    private static Object fromSNMPInstance(String instanceString, int snmpType) {
        switch (snmpType) {
            case 2: 
            case 65: {
                return new Integer(instanceString);
            }
            case 66: 
            case 70: {
                return new Long(instanceString);
            }
            case 112: {
                return MacAddress.fromInstanceString(instanceString).toOctetString();
            }
            case 64: {
                return instanceString;
            }
            case -128: {
                return OctetString.toDisplayString(OctetString.fromDottedDecimalForm(instanceString));
            }
            case 4: {
                return OctetString.fromDottedDecimalForm(instanceString);
            }
        }
        throw new RuntimeException("Cannot convert: " + instanceString + " to type " + snmpType);
    }

    private String createRowInstance(Object mo) throws Exception {
        Class<?> moClass = mo.getClass();
        SNMPTableEntry snmpTableEntryInfo = moClass.getAnnotation(SNMPTableEntry.class);
        if (snmpTableEntryInfo != null) {
            StringBuilder rowInstance = new StringBuilder();
            for (String indexColumn : snmpTableEntryInfo.indexColumns()) {
                boolean found = false;
                for (Method method : BeanUtils.getPropertyGetters(moClass)) {
                    if (!method.getName().equalsIgnoreCase("get" + indexColumn)) continue;
                    Object val = method.invoke(mo, new Object[0]);
                    rowInstance.append(".");
                    rowInstance.append(SNMPMOAccessSession.toInstanceString(method, val));
                    found = true;
                    break;
                }
                if (found) continue;
                throw new RuntimeException("Can't find index column property getter for [" + mo.getClass().getName() + "." + indexColumn + "]");
            }
            return rowInstance.toString();
        }
        return null;
    }

    protected VarBindList makeVarbindListForSet(Object mo, String[] includedProperties) throws Exception {
        Class<?> moClass = mo.getClass();
        String rowInstance = this.createRowInstance(mo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found rowInstance: " + rowInstance));
        }
        VarBindList varBindList = new VarBindList();
        HashSet<String> includes = null;
        if (includedProperties != null) {
            includes = new HashSet<String>();
            for (String include : includedProperties) {
                includes.add(include.toLowerCase());
            }
        }
        SNMPTableEntry snmpTableEntryInfo = moClass.getAnnotation(SNMPTableEntry.class);
        for (Method method : BeanUtils.getPropertyGetters(moClass)) {
            Object val;
            SNMPParameter snmpParamInfo = method.getAnnotation(SNMPParameter.class);
            if (snmpParamInfo == null || snmpTableEntryInfo != null && this.isIndexColumn(method, snmpTableEntryInfo) || snmpParamInfo.readOnly() || includes != null && !includes.contains(method.getName().substring(3).toLowerCase()) || (val = method.invoke(mo, new Object[0])) == null) continue;
            String vbOid = null;
            if (snmpTableEntryInfo != null) {
                vbOid = rowInstance == null ? snmpParamInfo.OID() : snmpParamInfo.OID() + "." + rowInstance;
            } else {
                vbOid = snmpParamInfo.OID();
                if (!vbOid.endsWith(".0")) {
                    vbOid = vbOid + ".0";
                }
            }
            VarBind varbind = new VarBind(method.getName().substring(3), vbOid, snmpParamInfo.type(), val);
            varBindList.add(varbind);
        }
        return varBindList;
    }

    private boolean isIndexColumn(Method getter, SNMPTableEntry snmpTableEntryInfo) {
        String propName = getter.getName().substring(3);
        for (String indexColumn : snmpTableEntryInfo.indexColumns()) {
            if (!indexColumn.equalsIgnoreCase(propName)) continue;
            return true;
        }
        return false;
    }

    protected VarBindList makeVarbindListForGet(Class<?> moClass, String rowInstance, String[] includedProperties) throws Exception {
        VarBindList varBindList = new VarBindList();
        HashSet<String> includes = null;
        if (includedProperties != null) {
            includes = new HashSet<String>();
            for (String include : includedProperties) {
                includes.add(include.toLowerCase());
            }
        }
        SNMPTableEntry snmpTableEntryInfo = moClass.getAnnotation(SNMPTableEntry.class);
        for (Method method : BeanUtils.getPropertyGetters(moClass)) {
            SNMPParameter snmpParamInfo = method.getAnnotation(SNMPParameter.class);
            if (snmpParamInfo == null || snmpTableEntryInfo != null && this.isIndexColumn(method, snmpTableEntryInfo) || includes != null && !includes.contains(method.getName().substring(3).toLowerCase())) continue;
            String vbOid = null;
            if (snmpTableEntryInfo != null) {
                vbOid = rowInstance == null ? snmpParamInfo.OID() : snmpParamInfo.OID() + "." + rowInstance;
            } else {
                vbOid = snmpParamInfo.OID();
                if (!vbOid.endsWith(".0")) {
                    vbOid = vbOid + ".0";
                }
            }
            VarBind varbind = new VarBind(method.getName().substring(3), vbOid, snmpParamInfo.type(), null);
            varBindList.add(varbind);
        }
        return varBindList;
    }

    @Override
    public Class<? extends Protocol> getProtocol() {
        return SNMP.class;
    }
}

