/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.services.mbean;

import com.bwanms.mediation.services.AgentEventProcessorManager;
import com.bwanms.mediation.services.impl.AgentEventProcessorManagerImpl;
import com.bwanms.mediation.services.impl.MORefreshRunnable;
import com.bwanms.mediation.services.mbean.AgentEventProcessorManagerServiceMBean;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ejb.MBeanProxyFactory;
import org.jboss.system.ServiceMBeanSupport;

public class AgentEventProcessorManagerService
extends ServiceMBeanSupport
implements AgentEventProcessorManagerServiceMBean {
    private AgentEventProcessorManagerImpl delegate;
    private int processorThreads = 5;
    private int maxEventQueueSize = 200;

    public String getName() {
        return "AgentEventProcessorManagerService";
    }

    public void startService() throws Exception {
        this.delegate = new AgentEventProcessorManagerImpl();
        this.delegate.setProcessorThreads(this.processorThreads);
        this.delegate.setMaxEventQueueSize(this.maxEventQueueSize);
        this.delegate.start();
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/AgentEventProcessorManager", MBeanProxyFactory.createProxy(AgentEventProcessorManager.class, this.getServiceName()));
    }

    public void stopService() throws Exception {
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind("bwanms/AgentEventProcessorManager");
        this.delegate.stop();
        this.delegate = null;
    }

    public long getEventCount() {
        return this.delegate == null ? 0L : this.delegate.getEventCount();
    }

    public long getProcessedEventCount() {
        return this.delegate == null ? 0L : this.delegate.getProcessedEventCount();
    }

    public long getAverageEventProcessingTime() {
        return this.delegate == null ? 0L : this.delegate.getAverageEventProcessingTime();
    }

    public long getAverageEventTransitTime() {
        return this.delegate == null ? 0L : this.delegate.getAverageEventTransitTime();
    }

    public long getEventDroppedCount() {
        return this.delegate == null ? 0L : this.delegate.getEventDroppedCount();
    }

    public int getProcessorThreads() {
        return this.processorThreads;
    }

    public void setProcessorThreads(int processorThreads) {
        this.processorThreads = processorThreads;
    }

    public int getMaxEventQueueSize() {
        return this.maxEventQueueSize;
    }

    public void setMaxEventQueueSize(int maxEventQueueSize) {
        this.maxEventQueueSize = maxEventQueueSize;
    }

    public void add(AgentEvent event) {
        this.delegate.add(event);
    }

    public boolean emit(AgentEvent event, Equipment source) {
        return this.delegate.emit(event, source);
    }

    public void process(AgentEvent event, Equipment source) {
        this.delegate.process(event, source);
    }

    public Integer retrieveAgentEventCount(String agentKey) {
        return this.delegate.retrieveAgentEventCount(agentKey);
    }

    public Integer retrieveProcessingAgentEventCount(String agentKey) {
        return this.delegate.retrieveProcessingAgentEventCount(agentKey);
    }

    public Integer retrieveMaxEventQueueSize() {
        return this.delegate.retrieveMaxEventQueueSize();
    }

    public void addMORefresh(MORefreshRunnable runnable) {
        this.delegate.addMORefresh(runnable);
    }
}

