/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.services.impl;

import com.bwanms.mediation.services.impl.MORefreshRunnable;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.NamedThreadFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MORefreshProcessorManagerImpl {
    private static final Logger log = Logger.getLogger(MORefreshProcessorManagerImpl.class);
    public static final String EXECUTORS_NAME = "MORefreshProcessorManager";
    private ExecutorService executor;
    private Set<Long> processingKeys;
    private Hashtable<Long, LinkedHashSet<MORefreshRunnable>> pending;
    private int processorThreads = 6;
    private int maxEventQueueSize = 5000;
    private long totalCount = 0L;
    private long processedCount = 0L;
    private long totalItemProcessingTime = 0L;
    private long droppedCount = 0L;
    private long duplicatedCount = 0L;

    public void start() {
        this.executor = Executors.newFixedThreadPool(this.processorThreads, new NamedThreadFactory(EXECUTORS_NAME));
        this.processingKeys = Collections.synchronizedSet(new HashSet());
        this.pending = new Hashtable();
    }

    public void stop() {
        ExecutorUtils.shutdownAndWait(EXECUTORS_NAME, this.executor);
    }

    public long getEventCount() {
        return this.totalCount;
    }

    public long getProcessedEventCount() {
        return this.processedCount;
    }

    public long getAverageEventProcessingTime() {
        return this.processedCount == 0L ? 0L : this.totalItemProcessingTime / this.processedCount;
    }

    public long getEventDroppedCount() {
        return this.droppedCount;
    }

    public int getProcessorThreads() {
        return this.processorThreads;
    }

    public void setProcessorThreads(int processorThreads) {
        this.processorThreads = processorThreads;
    }

    public int getMaxEventQueueSize() {
        return this.maxEventQueueSize;
    }

    public void setMaxEventQueueSize(int maxQueueSize) {
        this.maxEventQueueSize = maxQueueSize;
    }

    private void logStatistics() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nTotal count            : " + this.totalCount);
        sb.append("\nProcessing dropped     : " + this.droppedCount);
        sb.append("\nDuplicated count       : " + this.duplicatedCount);
        sb.append("\nProcessed count        : " + this.processedCount);
        sb.append("\nTo Process             : " + (this.totalCount - this.droppedCount - this.duplicatedCount - this.processedCount));
        sb.append("\nProcessing Time        : " + this.totalItemProcessingTime / 1000L + "s");
        sb.append("\nAverage Processing Time: " + (this.processedCount != 0L ? this.totalItemProcessingTime / this.processedCount : 0L));
        log.debug((Object)sb.toString());
    }

    public synchronized void addMORefreshOperation(MORefreshRunnable runnable) {
        ++this.totalCount;
        if (this.addPendingEvent(runnable)) {
            this.processPendingEvents(runnable.getEquipmentId());
        }
    }

    private synchronized boolean processingKey(Long equipmentId) {
        boolean ret = this.processingKeys.contains(equipmentId);
        if (!ret) {
            this.processingKeys.add(equipmentId);
        }
        return ret;
    }

    private boolean hasPendingEvents(Long equipmentId) {
        return this.pending.get(equipmentId) != null;
    }

    private void processPendingEvents(final Long equipmentId) {
        if (this.processingKey(equipmentId)) {
            log.debug((Object)("Already processing: " + equipmentId));
            return;
        }
        if (!this.hasPendingEvents(equipmentId)) {
            log.debug((Object)("No processing events for: " + equipmentId));
            this.processingComplete(equipmentId);
            return;
        }
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    long processTime = System.currentTimeMillis();
                    do {
                        long startTime = System.currentTimeMillis();
                        try {
                            final MORefreshRunnable agentEvent = MORefreshProcessorManagerImpl.this.getPendingEvent(equipmentId);
                            if (agentEvent == null) {
                                break;
                            }
                            new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                                @Override
                                public Object call() {
                                    try {
                                        agentEvent.run();
                                    }
                                    catch (RuntimeException re) {
                                        if (agentEvent.retryOnError()) {
                                            log.info((Object)("Retrying on: " + agentEvent));
                                            MORefreshProcessorManagerImpl.this.addPendingEvent(agentEvent);
                                            throw re;
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                    return null;
                                }
                            }).call();
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        MORefreshProcessorManagerImpl.this.processedCount++;
                        MORefreshProcessorManagerImpl.this.totalItemProcessingTime += System.currentTimeMillis() - startTime;
                    } while (System.currentTimeMillis() - processTime <= 5000L);
                }
                finally {
                    MORefreshProcessorManagerImpl.this.processingComplete(equipmentId);
                    if (log.isDebugEnabled()) {
                        MORefreshProcessorManagerImpl.this.logStatistics();
                    }
                    MORefreshProcessorManagerImpl.this.processPendingEvents(equipmentId);
                }
            }
        });
    }

    private synchronized boolean addPendingEvent(MORefreshRunnable runnable) {
        Long equipmentId = runnable.getEquipmentId();
        LinkedHashSet<MORefreshRunnable> pendingList = this.pending.get(equipmentId);
        if (pendingList == null) {
            pendingList = new LinkedHashSet();
            this.pending.put(equipmentId, pendingList);
        }
        if (pendingList.size() < this.maxEventQueueSize) {
            if (!pendingList.add(runnable)) {
                ++this.duplicatedCount;
                log.debug((Object)("Duplicated: [" + equipmentId + "]  MO: " + runnable));
                return false;
            }
            log.debug((Object)("Added to queue [" + equipmentId + "]  MO: " + runnable));
            return true;
        }
        ++this.droppedCount;
        log.info((Object)("Processing Queue size limit " + this.maxEventQueueSize + " exceeded for [" + equipmentId + "]. Processing dropped."));
        return false;
    }

    private void processingComplete(Long equipmentId) {
        this.processingKeys.remove(equipmentId);
    }

    private synchronized MORefreshRunnable getPendingEvent(Long equipmentId) {
        LinkedHashSet<MORefreshRunnable> pendingList = this.pending.get(equipmentId);
        if (pendingList == null) {
            return null;
        }
        MORefreshRunnable ret = null;
        Iterator it = pendingList.iterator();
        if (it.hasNext()) {
            try {
                ret = (MORefreshRunnable)it.next();
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        } else {
            this.pending.remove(equipmentId);
        }
        return ret;
    }
}

