/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.services.impl;

import com.bwanms.be.QueueHelper;
import com.bwanms.be.QueueI;
import com.bwanms.mediation.services.EventNotificationServiceIntf;
import com.bwanms.mediation.util.EventSequenceNumberGenerator;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.EventCategory;
import org.apache.log4j.Logger;

public class EventNotificationServiceImpl
implements EventNotificationServiceIntf {
    private static final Logger log = Logger.getLogger(EventNotificationServiceImpl.class);
    private static int BATCH_SIZE = 500;
    private static int BATCH_TIMEOUT = 500;
    private int batchMaxSize = BATCH_SIZE;
    private int batchInterval = BATCH_TIMEOUT;
    private QueueI<Event> alarmQueue;
    private QueueI<Event> eventQueue;

    public int getBatchMaxSize() {
        return this.batchMaxSize;
    }

    public void setBatchMaxSize(int batchMaxSize) {
        this.batchMaxSize = batchMaxSize;
    }

    public int getBatchInterval() {
        return this.batchInterval;
    }

    public void setBatchInterval(int batchInterval) {
        this.batchInterval = batchInterval;
    }

    public void start() {
        this.alarmQueue = QueueHelper.getQueueI("queue/EntityAlarm", Event.class);
        this.eventQueue = QueueHelper.getQueueI("queue/EntityEvent", Event.class);
    }

    public void stop() {
    }

    public void submitEvent(Event event) {
        event.setSequenceNumber(EventSequenceNumberGenerator.getNextSequenceNumber());
        if (event.getEventCategory() == EventCategory.Alarm.value()) {
            log.debug((Object)String.format("send alarm to BE %s", event.toString()));
            this.alarmQueue.add(event);
        } else {
            log.debug((Object)String.format("send event to BE %s", event.toString()));
            this.eventQueue.add(event);
        }
    }
}

