/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.services.impl;

import com.bwanms.ddi.AgentEventProcessor;
import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.ddi.EquipmentSynchronizationStrategy;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.ManagedNetworkHelper;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.NetworkScanMediationRequest;
import com.bwanms.mediation.ejb.NetworkScanSessionMessage;
import com.bwanms.mediation.services.AgentEventProcessorManager;
import com.bwanms.mediation.services.impl.MORefreshProcessorManagerImpl;
import com.bwanms.mediation.services.impl.MORefreshRunnable;
import com.bwanms.mediation.snmp.SNMPAutoDiscoveryEntry;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mediation.snmp.SNMPTrapFilter;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.AgentAuthentication;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.NetworkSNMPCommunity;
import com.bwanms.model.ObjectID;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.DDPluginUtil;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.NamedThreadFactory;
import com.bwanms.util.Settings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

public class AgentEventProcessorManagerImpl
implements AgentEventProcessorManager,
Runnable {
    private static final Logger log = Logger.getLogger(AgentEventProcessorManagerImpl.class);
    private ExecutorService executor;
    private Set<String> processingKeys;
    private Hashtable<String, ArrayList<AgentEvent>> pending;
    private HashMap<String, ArrayList<AgentEventProcessor>> processors;
    private BlockingQueue<AgentEvent> agentEventQueue = new LinkedBlockingQueue<AgentEvent>();
    private Hashtable<String, AtomicInteger> agentEventCountersMap = new Hashtable();
    private Thread agentEventQueueListener;
    private AtomicBoolean shouldStop;
    private int processorThreads = 6;
    private int maxEventQueueSize = 400;
    private long eventCount = 0L;
    private long emitCount = 0L;
    private long totalEventsEmitTime = 0L;
    private long processedEventCount = 0L;
    private long totalEventProcessingTime = 0L;
    private long totalEventTransitTime = 0L;
    private long eventDroppedCount = 0L;
    private AutoDiscoveryProcessor autoDiscoveryProcessor = null;
    private MORefreshProcessorManagerImpl moRefreshProcessor = null;

    public AgentEventProcessorManagerImpl() {
        this.configure();
    }

    private void configure() {
        this.processors = new HashMap();
        for (DDInterface dd : DDRegistry.getInstance().getDDInterfaces()) {
            for (AgentEventProcessor processor : dd.getAgentEventProcessors()) {
                ArrayList<AgentEventProcessor> regProcessors = this.processors.get(processor.getAgentEventClassName());
                if (regProcessors == null) {
                    regProcessors = new ArrayList();
                    this.processors.put(processor.getAgentEventClassName(), regProcessors);
                }
                regProcessors.add(processor);
                log.info((Object)("Registered: " + processor.getAgentEventClassName() + "[" + processor.getClass() + "]"));
            }
        }
        this.moRefreshProcessor = new MORefreshProcessorManagerImpl();
    }

    public void start() {
        this.executor = Executors.newFixedThreadPool(this.processorThreads, new NamedThreadFactory("AgentEventProcessor"));
        this.processingKeys = Collections.synchronizedSet(new HashSet());
        this.pending = new Hashtable();
        this.autoDiscoveryProcessor = new AutoDiscoveryProcessor();
        this.autoDiscoveryProcessor.start();
        this.shouldStop = new AtomicBoolean(false);
        this.agentEventQueueListener = new Thread(this);
        this.agentEventQueueListener.start();
        this.moRefreshProcessor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.debug((Object)"AgentEventQueueListener thread start");
        while (!this.shouldStop.get()) {
            try {
                AgentEvent evt = this.agentEventQueue.poll(100L, TimeUnit.MILLISECONDS);
                Hashtable<String, AtomicInteger> hashtable = this.agentEventCountersMap;
                synchronized (hashtable) {
                    if (evt != null) {
                        String key = evt.getAgentKey();
                        AtomicInteger counter = this.agentEventCountersMap.get(key);
                        if (counter != null && counter.decrementAndGet() <= 0) {
                            this.agentEventCountersMap.remove(key);
                        }
                    } else {
                        continue;
                    }
                }
                this.onMessage(evt);
            }
            catch (InterruptedException e) {
                log.info((Object)"", (Throwable)e);
            }
        }
        log.debug((Object)"AgentEventQueueListener thread stop");
    }

    private void onMessage(final AgentEvent agentEvent) {
        try {
            new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                @Override
                public Object call() {
                    AgentEventProcessorManagerImpl.this.processAgentEvent(agentEvent);
                    return null;
                }
            }).call();
        }
        catch (Exception e) {
            log.info((Object)"", (Throwable)e);
        }
    }

    public void stop() {
        ExecutorUtils.shutdownAndWait("AgentEventProcessorManager", this.executor);
        this.autoDiscoveryProcessor.stop();
        this.autoDiscoveryProcessor = null;
        this.shouldStop.set(true);
        this.agentEventQueueListener = null;
        this.moRefreshProcessor.stop();
        this.moRefreshProcessor = null;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public long getProcessedEventCount() {
        return this.processedEventCount;
    }

    public long getAverageEventProcessingTime() {
        return this.processedEventCount == 0L ? 0L : this.totalEventProcessingTime / this.processedEventCount;
    }

    public long getAverageEventTransitTime() {
        return this.eventCount == 0L ? 0L : this.totalEventTransitTime / this.eventCount;
    }

    public long getEventDroppedCount() {
        return this.eventDroppedCount;
    }

    public int getProcessorThreads() {
        return this.processorThreads;
    }

    public void setProcessorThreads(int processorThreads) {
        this.processorThreads = processorThreads;
    }

    public int getMaxEventQueueSize() {
        return this.maxEventQueueSize;
    }

    public void setMaxEventQueueSize(int maxQueueSize) {
        this.maxEventQueueSize = maxQueueSize;
    }

    private void logStatistics() {
        log.debug((Object)("Agent Events          : " + this.eventCount));
        log.debug((Object)("Agent Events Avg.Trnst: " + this.totalEventTransitTime / this.eventCount));
        log.debug((Object)("Agent Events Emitted  : " + this.emitCount));
        log.debug((Object)("Agent Events Emit Time: " + this.totalEventsEmitTime / 1000L + "s"));
        log.debug((Object)("Agent Events Avg.EmitT: " + (this.emitCount != 0L ? this.totalEventsEmitTime / this.emitCount : 0L)));
        log.debug((Object)("Agent Events Dropped  : " + this.eventDroppedCount));
        log.debug((Object)("Agent Events Processed: " + this.processedEventCount));
        log.debug((Object)("Agent Events Proc.Time: " + this.totalEventProcessingTime / 1000L + "s"));
        log.debug((Object)("Agent Events Avg.ProcT: " + (this.processedEventCount != 0L ? this.totalEventProcessingTime / this.processedEventCount : 0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AgentEvent event) {
        if (event.getAgentKey() != null) {
            Hashtable<String, AtomicInteger> hashtable = this.agentEventCountersMap;
            synchronized (hashtable) {
                if (this.agentEventQueue.offer(event)) {
                    AtomicInteger ai = this.agentEventCountersMap.get(event.getAgentKey());
                    if (ai == null) {
                        ai = new AtomicInteger(0);
                        this.agentEventCountersMap.put(event.getAgentKey(), ai);
                    }
                    ai.incrementAndGet();
                } else {
                    log.error((Object)("Error adding event to agent event queue : " + event));
                }
            }
        } else {
            log.error((Object)("Agent Event Key is null : " + event));
        }
    }

    private void processAgentEvent(AgentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processAgentEvent: " + event));
        }
        ++this.eventCount;
        this.totalEventTransitTime += System.currentTimeMillis() - event.getReceivedTime();
        ArrayList<AgentEventProcessor> regProcessors = this.processors.get(event.getClass().getName());
        Equipment targetEquipment = null;
        if (regProcessors != null) {
            AgentEventProcessor processor;
            Iterator<AgentEventProcessor> i$ = regProcessors.iterator();
            while (i$.hasNext() && (targetEquipment = (processor = i$.next()).accept(event)) == null) {
            }
        }
        if (targetEquipment == null) {
            log.debug((Object)("No processor for: [" + event.getClass() + " " + event.getAgentKey() + "]"));
            this.autoDiscoveryProcessor.process(event);
        } else if (this.emitEventInternal(event, targetEquipment)) {
            this.processEventInternal(event, targetEquipment);
        } else {
            ++this.eventDroppedCount;
            log.debug((Object)("[" + event.getAgentKey() + "]. Event dropped."));
        }
    }

    public boolean emit(AgentEvent event, Equipment source) {
        ++this.eventCount;
        this.totalEventTransitTime += System.currentTimeMillis() - event.getReceivedTime();
        boolean ret = this.emitEventInternal(event, source);
        return ret;
    }

    private synchronized boolean emitEventInternal(AgentEvent event, Equipment equipment) {
        EquipmentSynchronizationStrategy strategy = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(equipment.getClass().getName()).getSynchronizationStrategy(equipment, Helpers.getDDCallback());
        long startTime = System.currentTimeMillis();
        if (strategy.emitNmsEvent(event)) {
            this.totalEventsEmitTime += System.currentTimeMillis() - startTime;
            ++this.emitCount;
            return true;
        }
        return false;
    }

    public void process(AgentEvent event, Equipment source) {
        ++this.eventCount;
        this.totalEventTransitTime += System.currentTimeMillis() - event.getReceivedTime();
        ++this.emitCount;
        this.processEventInternal(event, source);
    }

    private synchronized void processEventInternal(AgentEvent event, Equipment targetEquipment) {
        if (this.addPendingEvent(event)) {
            Lock syncLock = LockManagerLocator.locate().getLock(Equipment.getSynchronizationLockKey(targetEquipment.getId()));
            this.processPendingEvents(event.getAgentKey(), new ObjectID(targetEquipment.getClass().getName(), Long.valueOf(targetEquipment.getId())), syncLock);
        }
    }

    public Integer retrieveAgentEventCount(String agentKey) {
        AtomicInteger atomicInteger = this.agentEventCountersMap.get(agentKey);
        if (atomicInteger == null) {
            return null;
        }
        try {
            return atomicInteger.get();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean processingKey(String agentKey) {
        boolean ret = this.processingKeys.contains(agentKey);
        if (!ret) {
            this.processingKeys.add(agentKey);
        }
        return ret;
    }

    private boolean hasPendingEvents(String agentKey) {
        return this.pending.get(agentKey) != null;
    }

    private void processPendingEvents(final String agentKey, final ObjectID id, final Lock syncLock) {
        if (this.processingKey(agentKey)) {
            log.debug((Object)("Already processing: " + agentKey));
            return;
        }
        if (!this.hasPendingEvents(agentKey)) {
            log.debug((Object)("No events for: " + agentKey));
            this.processingComplete(agentKey);
            return;
        }
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    long processTime = System.currentTimeMillis();
                    do {
                        long startTime;
                        block14: {
                            startTime = System.currentTimeMillis();
                            try {
                                if (!syncLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                                }
                                break block14;
                            }
                            catch (InterruptedException e) {
                                log.debug((Object)e, (Throwable)e);
                            }
                            break;
                        }
                        try {
                            final AgentEvent agentEvent = AgentEventProcessorManagerImpl.this.getPendingEvent(agentKey);
                            if (agentEvent == null) break;
                            new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                                @Override
                                public Object call() {
                                    Equipment targetEquipment = null;
                                    try {
                                        targetEquipment = (Equipment)Datastore.session().get(id.getClassName(), (Serializable)((Long)id.getIdentifier()));
                                        EquipmentSynchronizationStrategy strategy = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(targetEquipment.getClass().getName()).getSynchronizationStrategy(targetEquipment, Helpers.getDDCallback());
                                        strategy.processAgentEvent(agentEvent);
                                    }
                                    catch (MediationException e) {
                                        throw new RuntimeException("[" + targetEquipment + "] " + e);
                                    }
                                    return null;
                                }
                            }).call();
                        }
                        catch (Exception e) {
                            log.debug((Object)"", (Throwable)e);
                        }
                        finally {
                            syncLock.unlock();
                        }
                        AgentEventProcessorManagerImpl.this.processedEventCount++;
                        AgentEventProcessorManagerImpl.this.totalEventProcessingTime += System.currentTimeMillis() - startTime;
                    } while (System.currentTimeMillis() - processTime <= 5000L);
                }
                finally {
                    AgentEventProcessorManagerImpl.this.processingComplete(agentKey);
                    if (log.isDebugEnabled()) {
                        AgentEventProcessorManagerImpl.this.logStatistics();
                    }
                    AgentEventProcessorManagerImpl.this.processPendingEvents(agentKey, id, syncLock);
                }
            }
        });
    }

    private synchronized boolean addPendingEvent(AgentEvent event) {
        String agentKey = event.getAgentKey();
        ArrayList<AgentEvent> pendingList = this.pending.get(agentKey);
        if (pendingList == null) {
            pendingList = new ArrayList();
            this.pending.put(agentKey, pendingList);
        }
        if (pendingList.size() < this.maxEventQueueSize) {
            pendingList.add(event);
            return true;
        }
        ++this.eventDroppedCount;
        log.info((Object)("Queue size limit " + this.maxEventQueueSize + " exceeded for [" + agentKey + "]. Event dropped."));
        log.info((Object)("Pending for [" + agentKey + "] = " + this.agentEventCountersMap.get(agentKey)));
        return false;
    }

    private void processingComplete(String agentKey) {
        this.processingKeys.remove(agentKey);
    }

    private synchronized AgentEvent getPendingEvent(String agentKey) {
        ArrayList<AgentEvent> pendingList = this.pending.get(agentKey);
        if (pendingList == null) {
            return null;
        }
        AgentEvent ret = pendingList.remove(0);
        if (pendingList.size() == 0) {
            this.pending.remove(agentKey);
        }
        return ret;
    }

    public Integer retrieveProcessingAgentEventCount(String agentKey) {
        List pendingList = this.pending.get(agentKey);
        return pendingList == null ? 0 : pendingList.size();
    }

    public Integer retrieveMaxEventQueueSize() {
        return this.getMaxEventQueueSize();
    }

    public void addMORefresh(MORefreshRunnable runnable) {
        this.moRefreshProcessor.addMORefreshOperation(runnable);
    }

    private class AutoDiscoveryProcessor
    implements MessageListener {
        private long sessionId = -1L;
        private int retries = 3;
        private long timeout = 5000L;

        private AutoDiscoveryProcessor() {
        }

        public void start() {
            PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/NetworkScanMediationTopic", this);
        }

        public void stop() {
            PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this);
            if (this.sessionId != -1L) {
                MediationServiceRegistry.getNetworkScanMediationService().closeSession(this.sessionId);
                this.sessionId = -1L;
            }
        }

        public void process(AgentEvent event) {
            if (event instanceof SNMPTrapV1AgentEvent) {
                this.doAutoDiscovery(((SNMPTrapV1AgentEvent)event).getAgentIPAddress());
            } else if (event instanceof SNMPTrapAgentEvent) {
                this.doAutoDiscovery(((SNMPTrapAgentEvent)event).getAgentKey());
            }
        }

        private void doAutoDiscovery(String ipAddress) {
            SNMPAutoDiscoveryEntry entry;
            if (this.sessionId == -1L) {
                this.sessionId = MediationServiceRegistry.getNetworkScanMediationService().createSession();
                MediationServiceRegistry.getNetworkScanMediationService().startSession(this.sessionId);
            }
            if ((entry = SNMPTrapFilter.getAutoDiscoveryMap().get(ipAddress)) == null) {
                entry = new SNMPAutoDiscoveryEntry(ipAddress);
                SNMPTrapFilter.getAutoDiscoveryMap().put(ipAddress, entry);
            }
            entry.setLastAttemptTime(System.currentTimeMillis());
            NetworkIpAddressRange range = ManagedNetworkHelper.getRangeForIp(new IpAddress(ipAddress));
            if (range == null || range.getEnableAutoDiscovery() == null || !range.getEnableAutoDiscovery().booleanValue()) {
                log.debug((Object)("auto discovery range not found for " + ipAddress));
                return;
            }
            entry.setLocation(range.getLocation());
            List<NetworkSNMPCommunity> communities = ManagedNetworkHelper.getCommunities();
            communities.add(new NetworkSNMPCommunity(range.getReadCommunity(), range.getWriteCommunity()));
            IpAddress ip = new IpAddress(ipAddress);
            NetworkScanMediationRequest req = new NetworkScanMediationRequest(new IpAddressRange(ip, ip), new ArrayList<AgentAuthentication>(communities), this.retries, this.timeout, -1);
            MediationServiceRegistry.getNetworkScanMediationService().addRequest(this.sessionId, req);
        }

        public void onMessage(Message message) {
            block17: {
                try {
                    NetworkScanSessionMessage result = (NetworkScanSessionMessage)((ObjectMessage)message).getObject();
                    if (result.getSessionId() != this.sessionId) {
                        return;
                    }
                    if (result.getStatus() == 3) {
                        String readCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getReadCommunity();
                        String writeCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getWriteCommunity();
                        log.debug((Object)("auto discovery result[" + result.getSysName() + " " + result.getIpAddress() + ":" + result.getPort() + " ---- " + result.getSysObjID() + ", Read community:" + readCommunity + ", Write community:" + writeCommunity + "]"));
                        try {
                            String className = DDPluginUtil.getClassNameForOId(result.getSysObjID());
                            if (className == null) break block17;
                            SNMPAutoDiscoveryEntry entry = SNMPTrapFilter.getAutoDiscoveryMap().remove(result.getIpAddress());
                            log.info((Object)("auto discovery found [" + className + " on " + result.getIpAddress()));
                            Equipment equipment = DDRegistry.getInstance().createEquipment(new SNMPManagementInterface(result.getIpAddress(), Settings.instance().getSNMPSettingsDefaultPort(), readCommunity, writeCommunity, this.retries, this.timeout), DDPluginUtil.getClassNameForOId(result.getSysObjID()), result.getSysName());
                            try {
                                equipment.setLocation(entry.getLocation());
                                ServiceRegistry.getEntityManagerService().save(equipment);
                                log.info((Object)"auto discovery equipment created");
                                break block17;
                            }
                            catch (EntityAlreadyExistsException e) {
                                log.info((Object)"auto discovery equipment already discovered");
                                break block17;
                            }
                            catch (NullPointerException npe) {
                                log.info((Object)"auto discovery equipment maybe already discovered");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block17;
                    }
                    if (result.getStatus() == 5) {
                        log.debug((Object)("auto disocovery : no device at " + result.getIpAddress()));
                    } else if (result.getStatus() == 1) {
                        log.error((Object)"auto disocovery : session closed ");
                    } else if (result.getStatus() == 2) {
                        log.error((Object)"auto disocovery : session aborted ");
                    } else if (result.getStatus() == 4) {
                        log.error((Object)"auto disocovery : session completed");
                    }
                }
                catch (JMSException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)e, e);
                }
            }
        }
    }
}

