/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.local;

import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.impl.DiskFileSystemServiceImpl;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.util.Settings;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DiskFileSystemServiceLocal
implements FileSystemService {
    private static DiskFileSystemServiceLocal instance = null;
    private DiskFileSystemServiceImpl delegate;
    private String rootDirectory = Settings.instance().getApplicationDir() + "/filesystem";

    public static synchronized DiskFileSystemServiceLocal getInstance() {
        if (instance == null) {
            instance = new DiskFileSystemServiceLocal();
        }
        return instance;
    }

    private DiskFileSystemServiceLocal() {
    }

    public void start() {
        this.delegate = new DiskFileSystemServiceImpl();
        this.delegate.setRootDirectory(this.rootDirectory);
        this.delegate.start();
        PlatformFactory.getMediationLayerPlatform(null).getLookup().bind("bwanms/mediation/FileSystem", this.delegate);
    }

    public void stop() {
        PlatformFactory.getMediationLayerPlatform(null).getLookup().unbind("bwanms/mediation/FileSystem");
        this.delegate.stop();
        this.delegate = null;
    }

    public void deleteFile(String fileName) throws IOException {
        this.delegate.deleteFile(fileName);
    }

    public long openFile(String fileName, int mode) throws FileNotFoundException, IOException {
        return this.delegate.openFile(fileName, mode);
    }

    public void closeFile(long fileHandle) throws IOException {
        this.delegate.closeFile(fileHandle);
    }

    public void write(long fileHandle, byte[] data) throws IOException {
        this.delegate.write(fileHandle, data);
    }

    public byte[] read(long fileHandle, int maxLength) throws IOException {
        return this.delegate.read(fileHandle, maxLength);
    }

    public String getTemporaryFileName(String prefix, String suffix) {
        return this.delegate.getTemporaryFileName(prefix, suffix);
    }

    public void createFolder(String folderName) throws IOException {
        this.delegate.createFolder(folderName);
    }

    public void deleteFolder(String folderName, boolean cascade) throws IOException {
        this.delegate.deleteFolder(folderName, cascade);
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String[] listFiles(String folderName) throws IOException {
        return this.delegate.listFiles(folderName);
    }

    public String[] listSubFolders(String folderName) throws IOException {
        return this.delegate.listSubFolders(folderName);
    }

    public long length(long fileHandle) throws IOException {
        return this.delegate.length(fileHandle);
    }
}

