/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.impl;

import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.impl.AbstractFileTransferService;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.protocols.tftp.TftpClient;
import com.bwanms.protocols.tftp.TftpClientFactory;
import com.bwanms.protocols.tftp.TftpException;
import com.bwanms.protocols.tftp.TftpProgressMonitor;
import com.bwanms.protocols.tftp.TftpServerException;
import com.bwanms.protocols.tftp.TftpTimeoutException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TftpFileTransferServiceImpl
extends AbstractFileTransferService<TftpFileTransferRequest>
implements TftpFileTransferService {
    private static final Logger log = Logger.getLogger(TftpFileTransferServiceImpl.class);

    public TftpFileTransferServiceImpl(int maxRunningTransfers) {
        super(maxRunningTransfers, "topic/TftpMediationTopic");
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createTopic("topic/TftpMediationTopic");
    }

    @Override
    public void executeRequest(TftpFileTransferRequest request) throws MediationException {
        log.debug((Object)"Execute request");
        TftpClient client = new TftpClientFactory().createClient(request.getTftpServerAddress(), request.getTimeout(), request.getRetries());
        switch (request.getOperation()) {
            case 1: {
                this.performGet(client, request);
                break;
            }
            case 0: {
                this.performPut(client, request);
                break;
            }
            default: {
                throw new MediationException("Request type not supported: " + request.getOperation());
            }
        }
    }

    private void performGet(TftpClient tftpClient, TftpFileTransferRequest request) throws MediationException {
        OutputStream out = null;
        try {
            out = request.getLocalFile() == null ? new ByteArrayOutputStream() : this.getFileOutputStream(request.getLocalFile());
            tftpClient.get(request.getRemoteFile(), out, new ProgressMonitor());
            out.flush();
            if (request.getLocalFile() == null) {
                request.setFileData(((ByteArrayOutputStream)out).toByteArray());
            }
        }
        catch (TftpTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (TftpServerException e) {
            throw new AgentException(e);
        }
        catch (TftpException e) {
            throw new MediationException(e);
        }
        catch (IOException e) {
            throw new MediationException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.debug((Object)e.toString());
            }
        }
    }

    private void performPut(TftpClient tftpClient, TftpFileTransferRequest request) throws MediationException {
        InputStream in = null;
        try {
            in = request.getLocalFile() == null ? new ByteArrayInputStream(request.getFileData()) : this.getFileInputStream(request.getLocalFile());
            tftpClient.put(request.getRemoteFile(), in, new ProgressMonitor());
            request.setFileData(null);
        }
        catch (TftpTimeoutException e) {
            throw new CommunicationException(e);
        }
        catch (TftpServerException e) {
            throw new AgentException(e);
        }
        catch (TftpException e) {
            throw new MediationException(e);
        }
        catch (IOException e) {
            throw new MediationException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.debug((Object)e.toString());
            }
        }
    }

    private class ProgressMonitor
    implements TftpProgressMonitor {
        private String remoteFile;

        private ProgressMonitor() {
        }

        public void updateProgress(long bytesSent) {
            log.debug((Object)("TFTP [" + this.remoteFile + "] transferred" + bytesSent + " bytes"));
        }
    }
}

