/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.impl;

import com.bwanms.mediation.NetworkScanMediationRequest;
import com.bwanms.mediation.NetworkScanSession;
import com.bwanms.mediation.ejb.NetworkScanSessionMessage;
import com.bwanms.model.AgentAuthentication;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.protocols.snmp.SNMPException;
import com.bwanms.protocols.snmp.SNMPFactory;
import com.bwanms.protocols.snmp.SNMPSession;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.util.IpAddress;
import com.bwanms.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class NetworkScanMediationServiceImpl
implements NetworkScanSession {
    private transient Logger log = Logger.getLogger(NetworkScanMediationServiceImpl.class);
    private Map<Long, NetworkScanPrivateSession> sessions;
    private Map<Long, List<NetworkScanMediationRequest>> sessionRequests = Collections.synchronizedMap(new HashMap());
    private ExecutorService sessionPool;
    private Random random;
    private int SESSION_THREADS = 3;
    private int REQUEST_THREADS = 10;
    private int SCAN_THREADS = 100;
    private Thread monitor;

    public NetworkScanMediationServiceImpl() {
        this.sessions = Collections.synchronizedMap(new HashMap());
        this.sessionPool = Executors.newFixedThreadPool(this.SESSION_THREADS, new NamedThreadFactory(this.getClass().getName()));
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createTopic("topic/NetworkScanMediationTopic");
        this.monitor = new Thread(new Runnable(){

            public void run() {
                boolean run = true;
                while (run) {
                    try {
                        int activeSessions = ((ThreadPoolExecutor)NetworkScanMediationServiceImpl.this.sessionPool).getActiveCount();
                        long finishedSessions = ((ThreadPoolExecutor)NetworkScanMediationServiceImpl.this.sessionPool).getCompletedTaskCount();
                        NetworkScanMediationServiceImpl.this.log.debug((Object)("Active sessions: " + activeSessions + "\nFinished sessions: " + finishedSessions));
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        run = false;
                        NetworkScanMediationServiceImpl.this.log.info((Object)("monitor interrupted: " + ex.getMessage()));
                    }
                }
            }
        });
        this.monitor.start();
    }

    public long createSession() {
        NetworkScanPrivateSession session = new NetworkScanPrivateSession(this.generateSessionId());
        List initialRequest = Collections.synchronizedList(new ArrayList());
        this.sessions.put(session.getSessionId(), session);
        this.sessionRequests.put(session.getSessionId(), initialRequest);
        this.log.info((Object)("Created session [" + session.getSessionId() + "]"));
        return session.getSessionId();
    }

    public void addRequest(long sessionId, NetworkScanMediationRequest request) {
        if (this.sessionRequests.get(sessionId) == null) {
            throw new RuntimeException("Session does not exist");
        }
        this.sessionRequests.get(sessionId).add(request);
        this.log.debug((Object)("Added request for session [" + sessionId + "]"));
    }

    public void startSession(long sessionId) {
        NetworkScanPrivateSession session = this.sessions.get(sessionId);
        if (session == null) {
            throw new RuntimeException("Session does not exist");
        }
        this.sessionPool.submit(session);
        this.log.debug((Object)("Session start [" + session.getSessionId() + "]"));
    }

    public void closeSession(long sessionId) {
        if (this.sessions.get(sessionId) == null) {
            throw new RuntimeException("Session does not exist");
        }
        this.sessionRequests.get(sessionId).clear();
        this.sessionRequests.remove(sessionId);
        this.sessions.remove(sessionId).close();
        this.log.debug((Object)("Session closed [" + sessionId + "]"));
    }

    public void abortSession(long sessionId) {
        NetworkScanPrivateSession session = this.sessions.get(sessionId);
        if (session == null) {
            throw new RuntimeException("Session does not exist");
        }
        session.abort();
        this.log.debug((Object)("Session aborted [" + session.getSessionId() + "]"));
    }

    public boolean isSessionRunning(long sessionId) {
        NetworkScanPrivateSession session = this.sessions.get(sessionId);
        if (session != null) {
            return session.getIsRunning();
        }
        return false;
    }

    public void abortAllSessions() {
        this.sessionPool.shutdownNow();
    }

    private synchronized long generateSessionId() {
        return this.getRandom().nextLong();
    }

    private synchronized Random getRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName("java.security.SecureRandom");
                this.random = (Random)clazz.newInstance();
            }
            catch (Exception e) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    class NetworkScanPrivateSession
    implements Runnable {
        private final ExecutorService requestPool;
        private long sessionId;
        private boolean isRunning;
        private final ExecutorService scanPool;
        private long timeout = 5000L;
        private int retries = 2;
        private Map<NetworkScanMediationRequest, Runnable> requestFinished = new HashMap<NetworkScanMediationRequest, Runnable>();
        private Map<NetworkScanMediationRequest, Integer> addressCounter = new HashMap<NetworkScanMediationRequest, Integer>();
        private Thread monitor;

        public NetworkScanPrivateSession(final long sessionId) {
            this.sessionId = sessionId;
            this.requestPool = Executors.newFixedThreadPool(NetworkScanMediationServiceImpl.this.REQUEST_THREADS, new NamedThreadFactory(this.getClass().getName() + ".request"));
            this.scanPool = Executors.newFixedThreadPool(NetworkScanMediationServiceImpl.this.SCAN_THREADS, new NamedThreadFactory(this.getClass().getName() + ".scan"));
            this.isRunning = true;
            this.monitor = new Thread(new Runnable(){

                public void run() {
                    boolean run = true;
                    while (run) {
                        try {
                            int activeRequests = ((ThreadPoolExecutor)NetworkScanPrivateSession.this.requestPool).getActiveCount();
                            long finishedRequests = ((ThreadPoolExecutor)NetworkScanPrivateSession.this.requestPool).getCompletedTaskCount();
                            int activeScans = ((ThreadPoolExecutor)NetworkScanPrivateSession.this.scanPool).getActiveCount();
                            long finishedScans = ((ThreadPoolExecutor)NetworkScanPrivateSession.this.scanPool).getCompletedTaskCount();
                            NetworkScanMediationServiceImpl.this.log.debug((Object)("Session [" + sessionId + "] active req: " + activeRequests + " finished req: " + finishedRequests + " active scans: " + activeScans + " finished scans: " + finishedScans));
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex) {
                            run = false;
                            NetworkScanMediationServiceImpl.this.log.info((Object)("monitor interrupted: " + ex.getMessage()));
                        }
                    }
                }
            });
            this.monitor.start();
        }

        public void run() {
            while (this.isRunning) {
                if (((List)NetworkScanMediationServiceImpl.this.sessionRequests.get(this.getSessionId())).size() > 0) {
                    this.processRequest((NetworkScanMediationRequest)((List)NetworkScanMediationServiceImpl.this.sessionRequests.get(this.getSessionId())).remove(0));
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    NetworkScanMediationServiceImpl.this.log.debug((Object)e, (Throwable)e);
                }
            }
        }

        private void processRequest(final NetworkScanMediationRequest request) {
            this.requestFinished.put(request, new Runnable(){

                public void run() {
                    NetworkScanSessionMessage message = new NetworkScanSessionMessage();
                    message.setStatus(4);
                    message.setSessionId(NetworkScanPrivateSession.this.sessionId);
                    message.setRequest(request);
                    PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/NetworkScanMediationTopic", message);
                }
            });
            this.addressCounter.put(request, request.getRange().size());
            this.requestPool.submit(new Runnable(){

                public void run() {
                    NetworkScanMediationServiceImpl.this.log.debug((Object)("Starting request [" + request.getUserId() + "]"));
                    Iterator<IpAddress> iter = request.getRange().getIterator();
                    while (iter.hasNext()) {
                        final IpAddress ip = iter.next();
                        NetworkScanPrivateSession.this.scanPool.submit(new Runnable(){

                            public void run() {
                                NetworkScanPrivateSession.this.scanIpAddress(request, ip);
                                NetworkScanPrivateSession.this.scanFinished(request);
                            }
                        });
                    }
                    NetworkScanMediationServiceImpl.this.log.debug((Object)("Finished request [" + request.getUserId() + "]"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanFinished(NetworkScanMediationRequest request) {
            Map<NetworkScanMediationRequest, Integer> map = this.addressCounter;
            synchronized (map) {
                int counter = this.addressCounter.remove(request);
                if (counter > 0) {
                    --counter;
                }
                NetworkScanMediationServiceImpl.this.log.debug((Object)("Request [" + request.getUserId() + "] Scan pool counter (remaining to be scanned) is " + counter));
                if (counter == 0) {
                    NetworkScanMediationServiceImpl.this.log.debug((Object)("Request [" + request.getUserId() + "] Starting finish runnable"));
                    this.requestFinished.remove(request).run();
                } else {
                    this.addressCounter.put(request, counter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanIpAddress(NetworkScanMediationRequest request, IpAddress ip) {
            NetworkScanMediationServiceImpl.this.log.debug((Object)("Request [" + request.getUserId() + "] Starting scan for " + ip));
            int crtRetries = request.getRetries() != null ? request.getRetries() : this.retries;
            long crtTimeout = request.getTimeout() != null ? request.getTimeout() : this.timeout;
            boolean success = false;
            for (AgentAuthentication auth : request.getCredentials()) {
                SNMPManagementInterface ai = new SNMPManagementInterface(ip.toString(), 161, ((SNMPAgentAuthentication)auth).getReadCommunity(), ((SNMPAgentAuthentication)auth).getWriteCommunity(), 2, 5000L);
                SNMPSession snmpSession = null;
                try {
                    NetworkScanMediationServiceImpl.this.log.debug((Object)("Request [" + request.getUserId() + "] Starting SNMP session for " + ip + " ... credentials: " + ai.getReadCommunity() + "," + ai.getWriteCommunity()));
                    snmpSession = SNMPFactory.createSession(ai);
                    VarBindList vars = new VarBindList();
                    vars.add(new VarBind("sysObjectID", "1.3.6.1.2.1.1.2.0", 5, null));
                    vars.add(new VarBind("sysName", "1.3.6.1.2.1.1.5.0", -128, null));
                    VarBindList response = snmpSession.get(vars);
                    String sysObjID = (String)response.get(0).getVariable();
                    String sysName = (String)response.get(1).getVariable();
                    if (sysObjID.length() <= 0) continue;
                    NetworkScanSessionMessage message = new NetworkScanSessionMessage();
                    message.setSessionId(this.sessionId);
                    message.setIpAddress(ip.toString());
                    message.setPort(ai.getPort());
                    message.setCredentials(auth);
                    message.setSysObjID(sysObjID);
                    message.setSysName(sysName);
                    message.setRequest(request);
                    message.setStatus(3);
                    NetworkScanMediationServiceImpl.this.log.debug((Object)("Request [" + request.getUserId() + "] found agent @ " + ip + " ... publishing messsage"));
                    PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/NetworkScanMediationTopic", message);
                    success = true;
                    break;
                }
                catch (SNMPException e) {}
                continue;
                finally {
                    if (snmpSession == null) continue;
                    NetworkScanMediationServiceImpl.this.log.debug((Object)("Request [" + request.getUserId() + "] Closing SNMP session for " + ip + " ... credentials: " + ai.getReadCommunity() + "," + ai.getWriteCommunity()));
                    snmpSession.close();
                }
            }
            if (!success) {
                NetworkScanSessionMessage message = new NetworkScanSessionMessage();
                message.setRequest(request);
                message.setIpAddress(ip.toString());
                message.setPort(161);
                message.setStatus(5);
                message.setSessionId(this.sessionId);
                PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/NetworkScanMediationTopic", message);
            }
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public void close() {
            this.isRunning = false;
            this.requestPool.shutdown();
            this.scanPool.shutdown();
            this.monitor.interrupt();
            try {
                if (!this.requestPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.requestPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                if (!this.scanPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.scanPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            NetworkScanSessionMessage message = new NetworkScanSessionMessage();
            message.setStatus(1);
            message.setSessionId(this.sessionId);
            PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/NetworkScanMediationTopic", message);
            this.requestFinished.clear();
            this.addressCounter.clear();
        }

        public boolean getIsRunning() {
            return this.isRunning;
        }

        public void abort() {
            this.isRunning = false;
            this.requestPool.shutdownNow();
            this.scanPool.shutdownNow();
            this.monitor.interrupt();
            NetworkScanSessionMessage message = new NetworkScanSessionMessage();
            message.setStatus(2);
            message.setSessionId(this.sessionId);
            PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/NetworkScanMediationTopic", message);
            this.requestFinished.clear();
            this.addressCounter.clear();
        }
    }
}

