/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.impl;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.snmp.SNMPMOAccessSessionFactory;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.protocols.Protocol;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOAccessSessionImpl
implements MOAccessSession {
    private MOAccessSession delegate;
    private Class<? extends Protocol> delegateProtocol;

    public MOAccessSessionImpl(ManagementInterface agentInfo, NetworkResourceHandler partitionHandler) throws MediationException {
        if (!(agentInfo instanceof SNMPManagementInterface)) {
            throw new RuntimeException("Protocol not supported");
        }
        this.delegate = SNMPMOAccessSessionFactory.getInstance().createAccessSession(agentInfo, partitionHandler);
        this.delegateProtocol = this.delegate.getProtocol();
    }

    @Override
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass) throws MediationException {
        return this.delegate.fetchObject(networkResource, moClass);
    }

    @Override
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties) throws MediationException {
        return this.delegate.fetchObject(networkResource, moClass, includedProperties);
    }

    @Override
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String[] instances) throws MediationException {
        return this.delegate.fetchObject(networkResource, moClass, includedProperties, instances);
    }

    @Override
    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String startingInstance) throws MediationException {
        return this.delegate.fetchObject(networkResource, moClass, includedProperties, startingInstance);
    }

    @Override
    public void commitObject(String networkResource, Object mo) throws MediationException {
        this.delegate.commitObject(networkResource, mo);
    }

    @Override
    public void commitObject(String networkResource, Object mo, String[] includedProperties) throws MediationException {
        this.delegate.commitObject(networkResource, mo, includedProperties);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Class<? extends Protocol> getProtocol() {
        return this.delegateProtocol;
    }
}

