/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.impl;

import com.bwanms.mediation.FileSystemService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import org.apache.log4j.Logger;

public class DiskFileSystemServiceImpl
implements FileSystemService {
    private static final Logger log = Logger.getLogger(DiskFileSystemServiceImpl.class);
    private static final String TEMP_FOLDER = "temp";
    private static final Random random = new Random(System.currentTimeMillis());
    private File root;
    private long timeOut;
    private LinkedHashMap<Long, FileHandle> fileHandles;
    private String rootDirectory;
    private static long fileDescriptorSequence = 0L;

    public void start() {
        if (this.rootDirectory == null) {
            throw new IllegalArgumentException("Root directory must be specified");
        }
        log.info((Object)("root directory: " + this.rootDirectory));
        this.root = new File(this.rootDirectory);
        this.fileHandles = new LinkedHashMap(16, 0.75f, true);
        try {
            File tempDir;
            if (!this.root.exists()) {
                this.root.mkdir();
            }
            if (!(tempDir = new File(this.root, TEMP_FOLDER)).exists()) {
                tempDir.mkdir();
            }
            this.cleanupTemporaryFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.cleanup();
        this.root = null;
        this.fileHandles = null;
    }

    private static synchronized long getNewFileHandle() {
        return fileDescriptorSequence++;
    }

    private void cleanupTemporaryFiles() throws IOException {
        File tempFolder = new File(this.root, TEMP_FOLDER);
        File[] tempFiles = tempFolder.listFiles();
        log.info((Object)("Cleaning up " + tempFiles.length + " temporary files"));
        for (File file : tempFiles) {
            file.delete();
        }
    }

    public void deleteFile(String fileName) throws IOException {
        File file = new File(this.root, fileName);
        file.delete();
    }

    public synchronized long openFile(String fileName, int mode) throws FileNotFoundException, IOException {
        FileHandle fh = new FileHandle(fileName);
        fh.open(mode);
        this.fileHandles.put(fh.fh, fh);
        return fh.fh;
    }

    public synchronized void closeFile(long fileHandle) throws IOException {
        FileHandle fd = this.fileHandles.get(fileHandle);
        if (fd == null) {
            throw new IOException("Can't find handle");
        }
        this.fileHandles.remove(fd.fh);
        fd.close();
    }

    public void write(long fileHandle, byte[] data) throws IOException {
        FileHandle fd = this.fileHandles.get(fileHandle);
        fd.write(data);
    }

    public byte[] read(long fileHandle, int maxLength) throws IOException {
        FileHandle fd = this.fileHandles.get(fileHandle);
        return fd.read(maxLength);
    }

    public String getTemporaryFileName(String prefix, String suffix) {
        return "temp/" + prefix + "_" + System.currentTimeMillis() + "_" + random.nextLong() + "_suffix.tmp";
    }

    public void createFolder(String folderName) throws IOException {
        File folder = new File(this.root, folderName);
        folder.mkdirs();
    }

    public void deleteFolder(String folderName, boolean cascade) throws IOException {
    }

    private synchronized void cleanup() {
        for (FileHandle fileHandle : this.fileHandles.values()) {
            try {
                fileHandle.close();
            }
            catch (Exception e) {
                log.debug((Object)"", (Throwable)e);
            }
        }
        this.fileHandles.clear();
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String[] listFiles(String folderName) throws IOException {
        File folder = new File(this.root, folderName);
        if (!folder.exists()) {
            folder.mkdirs();
            if (!folder.exists()) {
                throw new IOException("Folder does not exist and cannot be created: " + folderName);
            }
        }
        File[] files = folder.listFiles();
        ArrayList<String> retList = new ArrayList<String>();
        for (File file : files) {
            if (!file.isFile()) continue;
            retList.add(folderName + "/" + file.getName());
        }
        String[] ret = new String[retList.size()];
        return retList.toArray(ret);
    }

    public String[] listSubFolders(String folderName) throws IOException {
        File folder = new File(this.root, folderName);
        File[] files = folder.listFiles();
        ArrayList<String> retList = new ArrayList<String>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            retList.add(folderName + "/" + file.getName());
        }
        String[] ret = new String[retList.size()];
        return retList.toArray(ret);
    }

    public long length(long fileHandle) throws IOException {
        FileHandle fd = this.fileHandles.get(fileHandle);
        return fd.length();
    }

    static /* synthetic */ long access$000() {
        return DiskFileSystemServiceImpl.getNewFileHandle();
    }

    private class FileHandle {
        long fh = DiskFileSystemServiceImpl.access$000();
        long timestamp = System.currentTimeMillis();
        private String fileName;
        private Object stream;
        private File file;
        int mode;

        public FileHandle(String fileName) {
            this.fileName = fileName;
        }

        public void open(int mode) throws FileNotFoundException, IOException {
            if (this.fileName == null) {
                throw new FileNotFoundException("File name is null");
            }
            this.timestamp = System.currentTimeMillis();
            this.mode = mode;
            this.file = new File(DiskFileSystemServiceImpl.this.root, this.fileName);
            if (mode == 0) {
                this.stream = new FileInputStream(this.file);
            } else if (mode == 1) {
                this.stream = new FileOutputStream(this.file);
            } else {
                throw new IOException("Mode RW not supported");
            }
        }

        public void write(byte[] data) throws IOException {
            this.timestamp = System.currentTimeMillis();
            if (this.mode != 1) {
                throw new IOException("File not open for write: " + this.fileName);
            }
            ((FileOutputStream)this.stream).write(data);
        }

        public byte[] read(int maxLen) throws IOException {
            this.timestamp = System.currentTimeMillis();
            if (this.mode != 0) {
                throw new IOException("File not open for read: " + this.fileName);
            }
            byte[] buff = new byte[maxLen];
            int readLen = ((FileInputStream)this.stream).read(buff);
            byte[] ret = new byte[Math.max(readLen, 0)];
            System.arraycopy(buff, 0, ret, 0, ret.length);
            return ret;
        }

        public long length() throws IOException {
            try {
                return this.file.length();
            }
            catch (SecurityException se) {
                throw new IOException(se.getMessage());
            }
        }

        public void close() throws IOException {
            if (this.mode == 0) {
                ((FileInputStream)this.stream).close();
            } else if (this.mode == 2) {
                ((FileOutputStream)this.stream).close();
            }
        }
    }
}

