/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.mediation.impl;

import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.filesystem.FileSystemFileInputStream;
import com.bwanms.mediation.filesystem.FileSystemFileOutputStream;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.NamedThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileTransferService<R extends FileTransferRequest>
implements FileTransferService<R> {
    private static Logger log = Logger.getLogger(AbstractFileTransferService.class);
    private Map<Long, Session> sessionMap = Collections.synchronizedMap(new HashMap());
    private ExecutorService executor;
    private HashMap<R, Long> runningRequests = new HashMap();
    private TreeSet<String> runningRequestsSynchronizer = new TreeSet();
    private int maxRunningRequests;
    private String topicName;
    private FileSystemService fileSystemService;
    private long sessionIdSequence = 0L;

    protected abstract void executeRequest(R var1) throws MediationException;

    protected void signalAbortRequest(R request) {
    }

    protected InputStream getFileInputStream(String fileName) throws IOException {
        return new FileSystemFileInputStream(this.fileSystemService, fileName);
    }

    protected OutputStream getFileOutputStream(String fileName) throws IOException {
        return new FileSystemFileOutputStream(this.fileSystemService, fileName);
    }

    public AbstractFileTransferService(int maxRunningRequests, String topicName) {
        this.maxRunningRequests = maxRunningRequests;
        this.topicName = topicName;
        this.fileSystemService = MediationServiceRegistry.getFileSystemService();
    }

    public void start() {
        this.executor = Executors.newCachedThreadPool(new NamedThreadFactory("AbstractFileTransferService"));
    }

    public void stop() {
        ExecutorUtils.shutdownAndWait(this.getClass().getName(), this.executor);
        this.executor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scheduleNextRequests() {
        boolean noMoreRequests = false;
        while (!noMoreRequests && this.runningRequests.size() < this.maxRunningRequests) {
            noMoreRequests = true;
            ArrayList<Session> sessionMapSnapshot = null;
            Map<Long, Session> map = this.sessionMap;
            synchronized (map) {
                sessionMapSnapshot = new ArrayList<Session>(this.sessionMap.values());
            }
            Iterator<Session> sessionIt = sessionMapSnapshot.iterator();
            while (sessionIt.hasNext() && this.runningRequests.size() < this.maxRunningRequests) {
                String syncKey;
                Object request;
                Session session = sessionIt.next();
                if (!session.isStarted() || (request = session.peekPendingRequest()) == null || (syncKey = ((FileTransferRequest)request).getSynchronizationKey()) != null && this.runningRequestsSynchronizer.contains(syncKey)) continue;
                session.requestIsToBeExecuted(request);
                noMoreRequests = false;
                this.runningRequests.put(request, session.id);
                if (syncKey != null) {
                    this.runningRequestsSynchronizer.add(syncKey);
                }
                this.notify(FileTransferEvent.requestStarted(session.id, request));
                this.scheduleRequest(request);
            }
        }
    }

    private void notify(FileTransferEvent ftEvent) {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().publish(this.topicName, ftEvent);
    }

    private void scheduleRequest(R request) {
        this.executor.submit(new Runnable((FileTransferRequest)request){
            final /* synthetic */ FileTransferRequest val$request;
            {
                this.val$request = fileTransferRequest;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    log.debug((Object)("Executing request [" + this.val$request.getUserData() + "]"));
                    AbstractFileTransferService.this.executeRequest(this.val$request);
                    AbstractFileTransferService.this.reportRequestCompleted(this.val$request);
                }
                catch (MediationException e) {
                    AbstractFileTransferService.this.reportRequestFailed(this.val$request, e);
                }
                catch (Throwable t) {
                    AbstractFileTransferService.this.reportRequestFailed(this.val$request, new MediationException(t));
                }
                finally {
                    AbstractFileTransferService.this.runningRequestsSynchronizer.remove(this.val$request.getSynchronizationKey());
                    AbstractFileTransferService.this.scheduleNextRequests();
                }
            }
        });
    }

    private final synchronized void reportRequestFailed(R request, MediationException error) {
        this.notify(FileTransferEvent.requestError(this.runningRequests.get(request), request, error));
        this.requestCompleted(request);
    }

    private final synchronized void reportRequestCompleted(R request) {
        this.notify(FileTransferEvent.requestCompleted(this.runningRequests.get(request), request));
        this.requestCompleted(request);
    }

    private void requestCompleted(R request) {
        log.debug((Object)("Request completed [" + ((FileTransferRequest)request).getUserData() + "]"));
        long sessionId = this.runningRequests.get(request);
        Session session = this.sessionMap.get(sessionId);
        session.requestCompleted(request);
        this.runningRequests.remove(request);
        if (session.isCompleted()) {
            this.sessionMap.remove(sessionId);
            log.debug((Object)("Session completed [" + sessionId + "]"));
        }
        log.debug((Object)("Running sessions: " + this.sessionMap.size()));
    }

    private final synchronized void reportRequestProgress(long progress) {
    }

    private synchronized long getNextSessionId() {
        return this.sessionIdSequence++;
    }

    @Override
    public long createSession() {
        Session session = new Session();
        this.sessionMap.put(session.id, session);
        return session.id;
    }

    @Override
    public void startSession(long sessionId) {
        log.debug((Object)("Starting session [" + sessionId + "]"));
        Session session = this.sessionMap.get(sessionId);
        session.start();
        this.scheduleNextRequests();
    }

    @Override
    public void addRequest(long sessionId, R request) {
        Session session = this.sessionMap.get(sessionId);
        session.addRequest(request);
    }

    @Override
    public void addRequests(long sessionId, List<R> requests) {
        Session session = this.sessionMap.get(sessionId);
        session.addRequests(requests);
        this.scheduleNextRequests();
    }

    @Override
    public void closeSession(long sessionId) {
        log.debug((Object)("Closing session [" + sessionId + "]"));
        Session session = this.sessionMap.get(sessionId);
        session.close();
    }

    @Override
    public void abortSession(long sessionId) {
    }

    @Override
    public boolean isSessionRunning(long sessionId) {
        Session session = this.sessionMap.get(sessionId);
        return !session.isCompleted();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Session {
        long id;
        private ArrayList<R> pendingRequests = new ArrayList();
        private ArrayList<R> runningRequests = new ArrayList();
        private ArrayList<R> completedRequests = new ArrayList();
        private boolean closed = false;
        private boolean started = false;

        public Session() {
            this.id = AbstractFileTransferService.this.getNextSessionId();
        }

        public synchronized void start() {
            this.started = true;
        }

        public synchronized void close() {
            this.closed = true;
        }

        public synchronized void addRequest(R request) {
            this.pendingRequests.add(request);
        }

        public synchronized void addRequests(List<R> requests) {
            this.pendingRequests.addAll(requests);
        }

        public synchronized R peekPendingRequest() {
            return this.pendingRequests.isEmpty() ? null : (FileTransferRequest)this.pendingRequests.get(0);
        }

        public synchronized void requestIsToBeExecuted(R request) {
            this.pendingRequests.remove(request);
            this.runningRequests.add(request);
        }

        public synchronized void requestCompleted(R request) {
            this.runningRequests.remove(request);
            this.completedRequests.add(request);
        }

        public synchronized boolean isCompleted() {
            return this.closed && this.pendingRequests.isEmpty() && this.runningRequests.isEmpty();
        }

        public synchronized boolean isStarted() {
            return this.started;
        }

        public synchronized R findCompletedRequest(Serializable userData) {
            for (FileTransferRequest request : this.completedRequests) {
                if (!userData.equals(request.getUserData())) continue;
                return request;
            }
            return null;
        }
    }
}

